package com.ebmwebsourcing.wsagreement10.impl;



import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.wsagreement10.api.element.KPITarget;
import com.ebmwebsourcing.wsagreement10.api.type.ServiceLevelObjectiveType;

import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbKPITargetType;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbServiceLevelObjectiveType;


class ServiceLevelObjectiveTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbServiceLevelObjectiveType> implements ServiceLevelObjectiveType {

	protected ServiceLevelObjectiveTypeImpl(XmlContext xmlContext, EJaxbServiceLevelObjectiveType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbServiceLevelObjectiveType> getCompliantModelClass() {
		return EJaxbServiceLevelObjectiveType.class;
	}


	@Override
	public KPITarget getKPITarget() {
		return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getKPITarget(), KPITarget.class);
	}


	@Override
	public boolean hasKPITarget() {
		return this.getKPITarget() != null;
	}


	@Override
	public void setKPITarget(KPITarget value) {
		if(value != null) {
			getModelObject().setKPITarget((EJaxbKPITargetType) ((AbstractJaxbXmlObjectImpl<?>) value).getModelObject());
		} else {
			getModelObject().setKPITarget(null);
		}
	}



}
