package com.ebmwebsourcing.wsagreement10.impl;



import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementContextType;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementRoleType;

import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementContextType;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementRoleType;


class AgreementContextTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbAgreementContextType> implements AgreementContextType {

	protected AgreementContextTypeImpl(XmlContext xmlContext, EJaxbAgreementContextType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbAgreementContextType> getCompliantModelClass() {
		return EJaxbAgreementContextType.class;
	}


	@Override
	public Object getAgreementInitiator() {
		return this.getModelObject().getAgreementInitiator();
	}


	@Override
	public void setAgreementInitiator(Object value) {
		getModelObject().setAgreementInitiator(value);
	}


	@Override
	public boolean hasAgreementInitiator() {
		return this.getModelObject().getAgreementInitiator() != null;
	}
	
	@Override
	public <B extends XmlObject> B findAgreementInitiator(Class<B> bindingInterfaceClass) {
		return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getAgreementInitiator(), bindingInterfaceClass);
	}


	@Override
	public Object getAgreementResponder() {
		return this.getModelObject().getAgreementResponder();
	}


	@Override
	public void setAgreementResponder(Object value) {
		getModelObject().setAgreementResponder(value);
	}


	@Override
	public boolean hasAgreementResponder() {
		return this.getAgreementResponder() != null;
	}
	
	@Override
	public <B extends XmlObject> B findAgreementResponder(Class<B> bindingInterfaceClass) {
		return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getAgreementResponder(), bindingInterfaceClass);
	}


	@Override
	public AgreementRoleType getServiceProvider() {
		if (getModelObject().getServiceProvider() == null)
			return null;
		return AgreementRoleType.valueOf(getModelObject().getServiceProvider().toString().toUpperCase());
	}


	@Override
	public void setServiceProvider(AgreementRoleType value) {
		if (value == null) {
			getModelObject().setServiceProvider(null);
		} else if (value.equals(AgreementRoleType.AGREEMENT_INITIATOR)) {
			getModelObject().setServiceProvider(EJaxbAgreementRoleType.AGREEMENT_INITIATOR);
		} else {
			getModelObject().setServiceProvider(EJaxbAgreementRoleType.AGREEMENT_RESPONDER);
		}
	} 



	@Override
	public boolean hasServiceProvider() {
		return this.getServiceProvider() != null;
	}


	@Override
	public Date getExpirationTime() {
		return this.getModelObject().getExpirationTime().toGregorianCalendar().getTime();
	}


	@Override
	public void setExpirationTime(Date value) {
		GregorianCalendar gCalendar = (GregorianCalendar) GregorianCalendar.getInstance();
		gCalendar.setTime(value);
		try {
			this.getModelObject().setExpirationTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar));
		} catch (DatatypeConfigurationException e) {
			throw new RuntimeException(e.getMessage(), e);
		}
	}


	@Override
	public boolean hasExpirationTime() {
		return this.getExpirationTime() != null;
	}


	@Override
	public String getTemplateId() {
		return this.getModelObject().getTemplateId();
	}


	@Override
	public void setTemplateId(String value) {
		this.getModelObject().setTemplateId(value);
	}


	@Override
	public boolean hasTemplateId() {
		return this.getTemplateId() != null;
	}


	@Override
	public String getTemplateName() {
		return this.getModelObject().getTemplateName();
	}


	@Override
	public void setTemplateName(String value) {
		this.getModelObject().setTemplateName(value);
	}


	@Override
	public boolean hasTemplateName() {
		return this.getTemplateName() != null;
	}


	@Override
	public <B extends XmlObject> B findExtendedElement(Class<B> itfElmtClass) {
		B[] children = createChildrenArray(getModelObject().getAny(), AbstractJaxbModelObject.class, ANY_QNAME, itfElmtClass);
		if(children.length == 0) {
			return null;
		}
		assert children.length == 1;
		return children[0];
	}

}
