package com.ebmwebsourcing.wsagreement10.impl;



import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.wsagreement10.api.element.Context;
import com.ebmwebsourcing.wsagreement10.api.element.Terms;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;

import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementContextType;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementType;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbTermTreeType;


class AgreementTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbAgreementType> implements AgreementType {

	protected AgreementTypeImpl(XmlContext xmlContext, EJaxbAgreementType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbAgreementType> getCompliantModelClass() {
		return EJaxbAgreementType.class;
	}


	@Override
	public boolean hasName() {
		return this.getName() != null;
	}


	@Override
	public String getName() {
		return this.getModelObject().getName();
	}


	@Override
	public void setName(String name) {
		this.getModelObject().setName(name);
	}


	@Override
	public Context getAgreementContext() {
		return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getContext(), Context.class);
	}


	@Override
	public void setAgreementContext(Context value) {
		if(value != null) {
			getModelObject().setContext((EJaxbAgreementContextType) ((AbstractJaxbXmlObjectImpl<?>) value).getModelObject());
		} else {
			getModelObject().setContext(null);
		}
	}


	@Override
	public boolean hasContext() {
		return this.getAgreementContext() != null;
	}


	@Override
	public Terms getTerms() {
		return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getTerms(), TermsImpl.class);
	}


	@Override
	public void setTerms(Terms value) {
		if(value != null) {
			getModelObject().setTerms((EJaxbTermTreeType) ((AbstractJaxbXmlObjectImpl<?>) value).getModelObject());
		} else {
			getModelObject().setTerms(null);
		}
	}


	@Override
	public boolean hasTerms() {
		return this.getTerms() != null;
	}


	@Override
	public String getAgreementId() {
		return this.getModelObject().getAgreementId();
	}


	@Override
	public void setAgreementId(String value) {
		this.getModelObject().setAgreementId(value);
	}


	@Override
	public boolean hasAgreementId() {
		return this.getAgreementId() != null;
	}


}
