package com.ebmwebsourcing.wsagreement10.impl;



import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceLevelObjective;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceScope;
import com.ebmwebsourcing.wsagreement10.api.type.GuaranteeTermType;
import com.ebmwebsourcing.wsagreement10.api.type.ServiceRoleType;

import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbGuaranteeTermType;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbServiceLevelObjectiveType;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbServiceRoleType;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbServiceSelectorType;


class GuaranteeTermTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbGuaranteeTermType> implements GuaranteeTermType {

	protected GuaranteeTermTypeImpl(XmlContext xmlContext, EJaxbGuaranteeTermType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbGuaranteeTermType> getCompliantModelClass() {
		return EJaxbGuaranteeTermType.class;
	}


	@Override
	public boolean hasName() {
		return this.getName() != null;
	}


	@Override
	public String getName() {
		return this.getModelObject().getName();
	}


	@Override
	public void setName(String name) {
		this.getModelObject().setName(name);
	}


	@Override
	public void addServiceScope(ServiceScope ss) {
		addToChildren(getModelObject().getServiceScope(), ss);
	}


	@Override
	public void clearServiceScopes() {
		clearChildren(getModelObject().getServiceScope(),
                EJaxbServiceSelectorType.class, ANY_QNAME);
	}


	@Override
	public ServiceRoleType getObligated() {
		if (getModelObject().getObligated() == null)
			return null;
		return ServiceRoleType.valueOf(getModelObject().getObligated().toString().toUpperCase());
	}



	@Override
	public ServiceLevelObjective getServiceLevelObjective() {
		return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getServiceLevelObjective(), ServiceLevelObjective.class);
	}


	@Override
	public ServiceScope getServiceScopeByOperationName(String opName) {
		assert opName != null;
		for (ServiceScope child : getServiceScopes()) {
			if (opName.equals(child.getServiceName()))
				return child;
		}
		return null;
	}


	@Override
	public ServiceScope[] getServiceScopes() {
		return createChildrenArray(getModelObject()
                .getServiceScope(), EJaxbServiceSelectorType.class, ANY_QNAME, 
                ServiceScope.class);
	}


	@Override
	public boolean hasObligated() {
		return this.getObligated() != null;
	}




	@Override
	public boolean hasServiceLevelObjective() {
		return this.getServiceLevelObjective() != null;
	}


	@Override
	public void removeServiceScope(ServiceScope ss) {
		removeFromChildren(getModelObject().getServiceScope(), ss);
	}


	@Override
	public void setObligated(ServiceRoleType value) {
		if (value == null) {
			getModelObject().setObligated(null);
		} else if (value.equals(ServiceRoleType.SERVICE_PROVIDER)) {
			getModelObject().setObligated(EJaxbServiceRoleType.SERVICE_PROVIDER);
		} else {
			getModelObject().setObligated(EJaxbServiceRoleType.SERVICE_CONSUMER);
		}
	}


	@Override
	public void setServiceLevelObjective(ServiceLevelObjective value) {
		if(value != null) {
			getModelObject().setServiceLevelObjective((EJaxbServiceLevelObjectiveType) ((AbstractJaxbXmlObjectImpl<?>) value).getModelObject());
		} else {
			getModelObject().setServiceLevelObjective(null);
		}
	}




}
