package com.ebmwebsourcing.wsagreement10.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.wsagreement10.api.type.KPITargetType;

import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbKPITargetType;

class KPITargetTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbKPITargetType>
        implements KPITargetType {

	protected KPITargetTypeImpl(XmlContext xmlContext, EJaxbKPITargetType jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbKPITargetType> getCompliantModelClass() {
        return EJaxbKPITargetType.class;
    }

    @Override
    public String getKPIName() {
        return this.getModelObject().getKPIName();
    }

    @Override
    public Object getCustomServiceLevel() {
        return this.getModelObject().getCustomServiceLevel();
    }

    @Override
    public <CustomServiceLevel extends XmlObject> CustomServiceLevel getCustomServiceLevel(
            Class<CustomServiceLevel> bindingInterfaceClass) {
        return getXmlContext().getXmlObjectFactory().wrap(
                this.getModelObject().getCustomServiceLevel(),
                bindingInterfaceClass);
    }

    @Override
    public boolean hasKPIName() {
        return this.getKPIName() != null;
    }

    @Override
    public boolean hasCustomServiceLevel() {
        return this.getCustomServiceLevel() != null;
    }

    @Override
    public void setKPIName(String value) {
        this.getModelObject().setKPIName(value);
    }

    @Override
    public void setCustomServiceLevel(Object value) {
        getModelObject().setCustomServiceLevel(value);
    }

}
