package com.ebmwebsourcing.wsagreement10.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.wsagreement10.Constants;


// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
        AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getName() {
        return "wsagreement10-impl";
    }
    
    
    @Override
    public String getOriginatingSchemaDir() {
        return "schema/wsagreement10";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "wsagreement10.xsd";
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.org.ggf.schemas.graap._2007._03.ws_agreement.ObjectFactory.class.getPackage();
    }

    
    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.WSAGREEMENT_NS_URI;
    }
    
    
    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return Constants.WSAGREEMENT_NS_PREFERRED_PREFIX;
    }
    
        
    
    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();
        
        // anoymous type
        
        // type
        factorableClasses.add(AgreementContextTypeImpl.class);
        factorableClasses.add(AgreementTemplateTypeImpl.class);
        factorableClasses.add(AgreementTypeImpl.class);
        factorableClasses.add(GuaranteeTermTypeImpl.class);
        factorableClasses.add(KPITargetTypeImpl.class);
        factorableClasses.add(ServiceDescriptionTermTypeImpl.class);
        factorableClasses.add(ServiceLevelObjectiveTypeImpl.class);
        factorableClasses.add(ServicePropertiesTypeImpl.class);
        factorableClasses.add(ServiceReferenceTypeImpl.class);
        factorableClasses.add(ServiceSelectorTypeImpl.class);
        factorableClasses.add(ServiceTermTypeImpl.class);
        factorableClasses.add(TermCompositorTypeImpl.class);
        factorableClasses.add(TermTreeTypeImpl.class);
        factorableClasses.add(TermTypeImpl.class);
        factorableClasses.add(VariableTypeImpl.class);
        factorableClasses.add(VariableSetTypeImpl.class);
        
        // element
        factorableClasses.add(AllImpl.class);
        factorableClasses.add(ContextImpl.class);
        factorableClasses.add(GuaranteeTermImpl.class);
        factorableClasses.add(KPITargetImpl.class);
        factorableClasses.add(ServiceDescriptionTermImpl.class);
        factorableClasses.add(ServiceLevelObjectiveImpl.class);
        factorableClasses.add(ServicePropertiesImpl.class);
        factorableClasses.add(ServiceReferenceImpl.class);
        factorableClasses.add(ServiceScopeImpl.class);
        factorableClasses.add(TermsImpl.class);
        factorableClasses.add(VariableImpl.class);
        factorableClasses.add(VariableSetImpl.class);
        
        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }
    
    
    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject ModelObjectObject)
            throws InstantiationException, IllegalAccessException,
            InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, ModelObjectObject);
    }

}
