package com.ebmwebsourcing.wsagreement10.impl;


import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.wsagreement10.api.element.Variable;
import com.ebmwebsourcing.wsagreement10.api.type.VariableSetType;

import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbServiceReferenceType;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbVariableSetType;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbVariableType;


class VariableSetTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbVariableSetType> implements VariableSetType {

	protected VariableSetTypeImpl(XmlContext xmlContext, EJaxbVariableSetType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbVariableSetType> getCompliantModelClass() {
		return EJaxbVariableSetType.class;
	}


	@Override
	public Variable[] getVariables() {
		return createChildrenArray(getModelObject()
                .getVariable(), EJaxbServiceReferenceType.class,
                ANY_QNAME, Variable.class);
	}


	@Override
	public void addVariable(Variable to) {
		addToChildren(getModelObject().getVariable(), to);
	}


	@Override
	public void removeVariable(Variable to) {
		removeFromChildren(getModelObject().getVariable(), to);
	}


	@Override
	public void clearVariables() {
		clearChildren(getModelObject().getVariable(),  EJaxbVariableType.class, ANY_QNAME);
	}


	@Override
	public Variable getVariableByName(String name) {
		return getChildByName(this.getVariables(), name);
	}

}
