package com.ebmwebsourcing.wscap12.impl;



import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Alert;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Info;

import easybox.oasis.names.tc.emergency.cap._1.EJaxbAlert;


final class AlertImpl extends AbstractJaxbXmlObjectImpl<EJaxbAlert> implements
Alert {

	AlertImpl(XmlContext xmlContext, EJaxbAlert jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbAlert> getCompliantModelClass() {
		return EJaxbAlert.class;
	}


	@Override
	public String getIdentifier() {
		return this.getModelObject().getIdentifier();
	}


	@Override
	public void setIdentifier(String value) {
		this.getModelObject().setIdentifier(value);
	}


	@Override
	public boolean hasIdentifier() {
		return this.getModelObject().getIdentifier() != null;
	}


	@Override
	public String getSender() {
		return this.getModelObject().getSender();
	}


	@Override
	public void setSender(String value) {
		this.getModelObject().setSender(value);
	}


	@Override
	public boolean hasSender() {
		return this.getModelObject().getSender() != null;
	}


	@Override
	public Date getSent() {
		return this.getModelObject().getSent().toGregorianCalendar().getTime();
	}


	@Override
	public void setSent(Date value) {
		GregorianCalendar gCalendar = (GregorianCalendar) GregorianCalendar.getInstance();
		gCalendar.setTime(value);
		try {
			this.getModelObject().setSent(DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar));
		} catch (DatatypeConfigurationException e) {
			throw new RuntimeException(e.getMessage(), e);
		}
	}


	@Override
	public boolean hasSent() {
		return this.getModelObject().getSent() != null;
	}


	@Override
	public String getStatus() {
		return this.getModelObject().getStatus();
	}


	@Override
	public void setStatus(String value) {
		this.getModelObject().setStatus(value);
	}


	@Override
	public boolean hasStatus() {
		return this.getModelObject().getStatus() != null;
	}


	@Override
	public String getMsgType() {
		return this.getModelObject().getMsgType();
	}


	@Override
	public void setMsgType(String value) {
		this.getModelObject().setMsgType(value);
	}


	@Override
	public boolean hasMsgType() {
		return this.getModelObject().getMsgType() != null;
	}


	@Override
	public String getSource() {
		return this.getModelObject().getSource();
	}


	@Override
	public void setSource(String value) {
		this.getModelObject().setSource(value);
	}


	@Override
	public boolean hasSource() {
		return this.getModelObject().getSource() != null;
	}


	@Override
	public String getScope() {
		return this.getModelObject().getScope();
	}


	@Override
	public void setScope(String value) {
		this.getModelObject().setScope(value);
	}


	@Override
	public boolean hasScope() {
		return this.getModelObject().getScope() != null;
	}


	@Override
	public String getRestriction() {
		return this.getModelObject().getRestriction();
	}


	@Override
	public void setRestriction(String value) {
		this.getModelObject().setReferences(value);
	}


	@Override
	public boolean hasRestriction() {
		return this.getModelObject().getRestriction() != null;
	}


	@Override
	public String getAddresses() {
		return this.getModelObject().getAddresses();
	}


	@Override
	public void setAddresses(String value) {
		this.getModelObject().setAddresses(value);
	}


	@Override
	public boolean hasAddresses() {
		return this.getModelObject().getAddresses() != null;
	}


	@Override
	public String[] getCodes() {
		return (String[]) this.getModelObject().getCode().toArray();
	}


	@Override
	public void addCode(String c) {
		this.getModelObject().getCode().add(c);
	}


	@Override
	public void removeCode(String c) {
		this.getModelObject().getCode().remove(c);
	}


	@Override
	public void clearCodes() {
		this.getModelObject().getCode().clear();
	}


	@Override
	public String getNote() {
		return this.getModelObject().getNote();
	}


	@Override
	public void setNote(String value) {
		this.getModelObject().setNote(value);
	}


	@Override
	public boolean hasNote() {
		return this.getModelObject().getNote() != null;
	}


	@Override
	public String getReferences() {
		return this.getModelObject().getReferences();
	}


	@Override
	public void setReferences(String value) {
		this.getModelObject().setReferences(value);
	}


	@Override
	public boolean hasReferences() {
		return this.getModelObject().getReferences() != null;
	}


	@Override
	public String getIncidents() {
		return this.getModelObject().getIncidents();
	}


	@Override
	public void setIncidents(String value) {
		this.getModelObject().setIncidents(value);
	}


	@Override
	public boolean hasIncidents() {
		return this.getModelObject().getIncidents() != null;
	}


	@Override
	public Info[] getInfos() {
		return createChildrenArray(getModelObject()
                .getInfo(), EJaxbAlert.Info.class, ANY_QNAME, 
                Info.class);
	}


	@Override
	public void addInfo(Info info) {
		addToChildren(getModelObject().getInfo(), info);
	}


	@Override
	public void removeInfo(Info info) {
		removeFromChildren(getModelObject().getInfo(), info);
	}


	@Override
	public void clearInfos() {
		clearChildren(getModelObject().getInfo(),
				EJaxbAlert.Info.class, ANY_QNAME);
	}


	@Override
	public Info getInfoBySenderName(String name) {
		for (Info child : getInfos()) {
			if (name.equals(child.getSenderName()))
				return child;
		}
		return null;
	}


	

}
