package edu.uga.cs.lsdis.sawsdl;


import javax.xml.namespace.QName;

/**
 * Representation of the SAWSDL definition  
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer  
 *
 */
public interface Definition extends javax.wsdl.Definition {

    /**
     * Create a new modelReference.
     * @return the newly created modelReference.
     */
    ModelReference createModelReference();

    /**
     * Get the specified portType. Also checks imported documents.
     * note that this method returns the semantically annotated
     * portType
     *
     * @param name the name of the desired portType.
     * @return the corresponding portType, or null if there wasn't
     *         any matching portType. This
     */
    PortType getSemanticPortType(QName name);

    /**
     * Add a sawsdl portType to this WSDL description.
     * This is an overloaded version of the addPortType method
     * @param portType the portType to be added
     */
    void addPortType(PortType portType);

    /**
     * Add a semantically annotated message to this WSDL description.
     * overloaded version of the addMessage method
     * @see javax.wsdl.Definition#addMessage(javax.wsdl.Message)
     * @param message the message to be added
     */
    void addMessage(Message message);

    /**
     * Get the specified message as a semantically annotated message object.
     *  Also checks imported documents.
     * @see javax.wsdl.Definition#getMessage(javax.xml.namespace.QName)
     * @param name the name of the desired message.
     * @return the corresponding message, or null if there wasn't
     * any matching message
     */
    Message getSemanticMessage(QName name);

    /**
     * Remove the specified message from this definition.
     * @see javax.wsdl.Definition#removeMessage(javax.xml.namespace.QName)
     * @param name the name of the message to remove
     * @return the message previously associated with this qname, if there
     * was one; may return null
     * We might want to rethink this though
     */
     Message removeSemanticMessage(QName name);



}
