package edu.uga.cs.lsdis.sawsdl;


/**
 * Representation of the SAWSDL message. The message
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public interface Message extends javax.wsdl.Message {

    /**
     * Add a semantically annotated part to this message.
     * @see  javax.wsdl.Message#addPart(javax.wsdl.Part)
     * @param part the part to be added
     */
    void addPart(Part part);

    /**
     * Get the specified semantically annotated part.
     * @see javax.wsdl.Message#getPart(String)
     * @param name the name of the desired part.
     * @return the corresponding part, or null if there wasn't
     * any matching part
     */
    public Part getSemanticPart(String name);

    /**
     * Remove the specified part.
     *  @see javax.wsdl.Message#removePart(String)
     * @param name the name of the part to be removed.
     * @return the part which was removed
     */
    public Part removeSemanticPart(String name);
}
