package edu.uga.cs.lsdis.sawsdl;

import java.net.URI;

/**
 * This interface represents a ModelReference.
 * 

 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 *
 */
public interface ModelReference {

    /**
     * Get the model reference URI
     * @return the URI object
     */
    public URI getURI();

    /**
     * set the model reference URI
     * @param uri  - The URI to be set to this model reference
     */
    public void setURI(URI uri);

    /**
     *  Get the parent object for this model reference
     * @return the parent object
     */
    public Object getParent();

    /**
     * Set the parent for this model reference
     * @param parent the parent object for this model reference
     */
    public void setParent(Object parent);
}
