package edu.uga.cs.lsdis.sawsdl.extensions.schema;

import edu.uga.cs.lsdis.sawsdl.Definition;
import edu.uga.cs.lsdis.sawsdl.ModelReference;
import edu.uga.cs.lsdis.sawsdl.WSDLSException;
import org.w3c.dom.Element;

import java.net.URISyntaxException;
import java.util.Set;

/**
 * Modified schema extension that support the extraction of the
 * model references
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public interface Schema extends javax.wsdl.extensions.schema.Schema {
    /**
     * Set the modelReference on the element located by the given path.
     * @param startElement The starting element of the path
     * @param path
     * @param modelReference The desired modelReference
     */
    public void addModelReference(Element startElement, String path, ModelReference modelReference)
            throws WSDLSException;

    /**
     * Get the model references pertaining to the schema construct given by the
     * xpath (path)
     * @param startElement Root of the XPath
     * @param path XPath expression that returns a schema construct
     * @param def
     * @return  a list of model references
     * @throws WSDLSException
     */
    public Set<ModelReference> getModelReferences(Element startElement, String path, Definition def)
            throws WSDLSException, URISyntaxException;

     /**
     * Get the model references pertaining to the schema construct given by the
     * xpath (path)
     * @param startElement Root of the XPath
     * @param path XPath expression that returns a schema construct
     * @param def
     * @return  a single model reference
     * @throws WSDLSException
     */
    public ModelReference getModelReference(Element startElement, String path, Definition def) throws WSDLSException, URISyntaxException;

    /**
     * Set the model reference to the element (type) given by the Xpath (path)
     * @param startElement
     * @param path  (a valid xpath expression)
     * @param refs
     * @throws WSDLSException
     */
    public void setModelReferences(Element startElement, String path, Set<ModelReference> refs) throws WSDLSException;


    /**
     * add a single lifting schema mapping on the element located by the given path.
     * if there is already a mapping this mapping will be added to the list
     * @param startElement The starting element of the path
     * @param path  (a valid xpath expression)
     * @param liftingMapping The desired lifting mapping
     * @param def
     */
    public void addLiftingMapping(Element startElement, String path, String liftingMapping, Definition def) throws WSDLSException, URISyntaxException;

    /**
     * Get the lifting schema mappings pertaining to the schema construct given by the
     * xpath (path)
     * @param startElement Root of the XPath
     * @param path XPath expression that returns a schema construct
     * @param def
     * @return  a list of strings
     * @throws WSDLSException
     */
    public Set<String> getLiftingMappings(Element startElement, String path, Definition def) throws WSDLSException, URISyntaxException;

    /**
     * Set the lifting schema mappings  to the element (type) given by the Xpath (path)
     * @param startElement
     * @param path  (a valid xpath expression)
     * @param mappings
     * @throws WSDLSException
     */
    public void setLiftingMappings(Element startElement, String path, Set<String> mappings) throws WSDLSException;

    /**
     * add a single lifting schema mapping on the element located by the given path.
     * if there is already a mapping this mapping will be added to the list
     * @param startElement The starting element of the path
     * @param path  (a valid xpath expression)
     * @param liftingMapping The desired lifting mapping
     * @param def
     */
    public void addLoweringMapping(Element startElement, String path, String liftingMapping, Definition def) throws WSDLSException, URISyntaxException;

    /**
     * Get the lowering schema mappings pertaining to the schema construct given by the
     * xpath (path)
     * @param startElement Root of the XPath
     * @param path XPath expression that returns a schema construct
     * @param def
     * @return  a list of strings
     * @throws WSDLSException
     */
    public Set<String> getLoweringMappings(Element startElement, String path, Definition def) throws WSDLSException, URISyntaxException;

    /**
     * Set the lowering schema mappings  to the element (type) given by the Xpath (path)
     * This operation will *remove* any existing schema mappings
     * @param startElement
     * @param path  (a valid xpath expression)
     * @param mappings
     * @throws WSDLSException
     */
    public void setLoweringMappings(Element startElement, String path, Set<String> mappings) throws WSDLSException;

}
