/*
 * (c) 
 */

package edu.uga.cs.lsdis.sawsdl.impl;

import edu.uga.cs.lsdis.sawsdl.*;

import javax.xml.namespace.QName;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

/**
 * This class represents a SAWSDL definition. This is a direct
 * extension of the wsdl4j definition
 *
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */

public class DefinitionImpl extends com.ibm.wsdl.DefinitionImpl implements Definition {

    protected List modelReferenceList = new ArrayList();
    protected List ontologyNamespaces = new ArrayList();

    /**
     * Get all the Parts which has a modelReference with the specified namespace and concept.
     *
     * @param namespace The namespace of the modelReference
     * @param concept   The concept of the modelReference
     * @return All the Parts which has a modelReference with the specified namespace and concept.
     */
    public List getPartsByModelReference(URI namespace, String concept) {
        throw new UnsupportedOperationException(" not implemented yet !");
    }

    /**
     * Get all the Operations which has a modelReference with the specified namespace and concept.
     *
     * @param namespace The namespace of the modelReference
     * @param concept   The concept of the modelReference
     * @return All the Operations which has a modelReference with the specified namespace and concept.
     */
    public List getOperationsByModelReference(URI namespace, String concept) {
        throw new UnsupportedOperationException(" not implemented yet !");
    }

    /**
     * Get all the XSD Elements which has a modelReference with the specified namespace and concept.
     *
     * @param namespace The namespace of the modelReference
     * @param concept   The concept of the modelReference
     * @return All the XSD Elements which has a modelReference with the specified namespace and concept.
     */
    public List getXSDElementsByModelReference(URI namespace, String concept) {
       throw new UnsupportedOperationException(" not implemented yet !");
    }

    /**
     * Get all the XSD ComplexTypes which has a modelReference with the specified namespace and concept.
     *
     * @param namespace The namespace of the modelReference
     * @param concept   The concept of the modelReference
     * @return All the XSD ComplexTypes which has a modelReference with the specified namespace and concept.
     */
    public List getXSDComplexTypeByModelReference(URI namespace, String concept) {
       throw new UnsupportedOperationException(" not implemented yet !");
    }

    /**
     * Set the document base URI of this definition. Can be used to
     * represent the origin of the Definition, and can be exploited
     * when resolving relative URIs (e.g. in &lt;import&gt;s).
     *
     * @param documentBaseURI the document base URI of this definition
     */

    /**
     * Create a new modelReference.
     *
     * @return the newly created modelReference.
     */
    public ModelReference createModelReference() {
        return new ModelReferenceImpl();
    }


    /**
     * Create a new operation.
     *
     * @return the newly created operation
     */
    public Operation createOperation() {
        return new OperationImpl();
    }


    /**
     * Create a new part.
     *
     * @return the newly created part
     */
    public Part createPart() {
        return new PartImpl();
    }


    /**
     * Create a new port type.
     *
     * @return the newly created port type
     */
    public PortType createPortType() {
        return new PortTypeImpl();
    }


    /**
     * Get the specified portType. Also checks imported documents.
     * note that this method returns the semantically annotated
     * portType
     *
     * @param name the name of the desired portType.
     * @return the corresponding portType, or null if there wasn't
     *         any matching portType. This
     */
    public PortType getSemanticPortType(QName name) {
        return (PortType) this.getPortType(name);
    }

    /**
     * Add a sawsdl portType to this WSDL description.
     *
     * @param portType the portType to be added
     */
    public void addPortType(PortType portType) {
        this.addPortType((javax.wsdl.PortType)portType);
    }

    /**
     * Add a semantically annotated message to this WSDL description.
     * overloaded version of the addMessage method
     *
     * @param message the message to be added
     * @see javax.wsdl.Definition#addMessage(javax.wsdl.Message)
     */
    public void addMessage(Message message) {
        this.addMessage((javax.wsdl.Message)message);
    }

    /**
     * Get the specified message as a semantically annotated message object.
     * Also checks imported documents.
     *
     * @param name the name of the desired message.
     * @return the corresponding message, or null if there wasn't
     *         any matching message
     * @see javax.wsdl.Definition#getMessage(javax.xml.namespace.QName)
     */
    public Message getSemanticMessage(QName name) {
        return (Message)this.getMessage(name);
    }

    /**
     * Remove the specified message from this definition.
     *
     * @param name the name of the message to remove
     * @return the message previously associated with this qname, if there
     *         was one; may return null
     * @see javax.wsdl.Definition#removeMessage(javax.xml.namespace.QName)
     */
    public Message removeSemanticMessage(QName name) {
        return (Message)this.removeMessage(name);
    }

    /**
     * Create a new message. This message is
     * a semantically annotated message object
     * @return the newly created message
     */
    public javax.wsdl.Message createMessage() {
        return new MessageImpl();
    }
}
