/*
 * (c) 
 */

package edu.uga.cs.lsdis.sawsdl.impl;

import edu.uga.cs.lsdis.sawsdl.Definition;
import edu.uga.cs.lsdis.sawsdl.ModelReference;
import edu.uga.cs.lsdis.sawsdl.Operation;
import edu.uga.cs.lsdis.sawsdl.PortType;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * This class represents a port type. It contains information about
 * operations associated with this port type.
 *
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public class PortTypeImpl extends com.ibm.wsdl.PortTypeImpl implements PortType
{

    protected Set<ModelReference> modelReferences = new HashSet<ModelReference>();

    /**
     * Set the modelReference specification located by the given path.
     * @param modelReference The new modelReference value
     */
    public void addModelReference(ModelReference modelReference){
        modelReferences.add(modelReference);
        addModelReftoExtensionAttribs(modelReference);
    }


    public Set<ModelReference> getModelReferences() {
        return modelReferences;
    }

    public void setModelReferences(Set<ModelReference> refs) {
        modelReferences = refs;
        //update the attriblist by adding
        for (ModelReference modelReference : refs) {
        	addModelReftoExtensionAttribs(modelReference);
		}
        //remove model reference from extension attributes
        if (refs==null || refs.isEmpty()){
        	extensionAttributes.remove(Constants.Q_ATTR_MODELREF);
        }
    }

    /**
     * Adds the model refs to extension attributes hash map - needed
     * for serialization
     */
    private void addModelReftoExtensionAttribs(ModelReference ref){
    	List l = null;
    	if (!extensionAttributes.containsKey(Constants.Q_ATTR_MODELREF)){
    		extensionAttributes.put(Constants.Q_ATTR_MODELREF, new ArrayList());
    	}
    	
    	l = (List)extensionAttributes.get(Constants.Q_ATTR_MODELREF);
    	if (!l.contains(ref.getURI().toString())){
    		l.add(ref.getURI().toString());
    	}
    }

    public ModelReference getModelReference() {
         if(modelReferences.size() < 0)
            return null;
        return modelReferences.toArray(new ModelReference[modelReferences.size()])[0];
    }

    /**
     * Overloaded method to add a semantic operation directly
     *
     * @param operation
     * @see javax.wsdl.PortType#addOperation(javax.wsdl.Operation)
     */
    public void addOperation(Operation operation) {
        this.addOperation((javax.wsdl.Operation)operation);
    }

    /**
     * gets the semantic operation
     * @param name
     * @param inputName
     * @param outputName
     * @return the semantically annotated operation object
     * @see javax.wsdl.PortType#getOperation(String, String, String)
     */
    public Operation getSemanticOperation(String name, String inputName, String outputName) {
        return (Operation)this.getOperation(name,inputName,outputName);
    }


    /**
     * removes  a semantic operation.
     *
     * @param name
     * @param inputName
     * @param outputName
     * @return the semantically annotated operation object
     * @see javax.wsdl.PortType#removeOperation(String, String, String)
     */
    public Operation removeSemanticOperation(String name, String inputName, String outputName) {
        return (Operation)this.removeOperation(name,inputName,outputName);
    }
}
