package edu.uga.cs.lsdis.sawsdl.impl.extensions;

import com.ibm.wsdl.extensions.PopulatedExtensionRegistry;
import com.ibm.wsdl.extensions.schema.SchemaConstants;
import edu.uga.cs.lsdis.sawsdl.impl.Constants;
import edu.uga.cs.lsdis.sawsdl.impl.extensions.sawsdl.AttrExtensionsImpl;
import edu.uga.cs.lsdis.sawsdl.impl.extensions.sawsdl.AttrExtensionsSerializer;

import javax.wsdl.*;
import javax.wsdl.extensions.AttributeExtensible;

/**
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public class ExtensionsRegistry extends PopulatedExtensionRegistry {

    public ExtensionsRegistry() {
        super();


        //overide the registration for schemas
        mapExtensionTypes(Types.class, SchemaConstants.Q_ELEM_XSD_2001,
                edu.uga.cs.lsdis.sawsdl.impl.extensions.schema.SchemaImpl.class);


        // add out custom extensibility element for the attrExtensions
        AttrExtensionsSerializer attrExtensionsSerDeser = new AttrExtensionsSerializer();

        registerSerializer(edu.uga.cs.lsdis.sawsdl.Operation.class,
                Constants.Q_ELEM_ATTR_EXTENSIONS,
                attrExtensionsSerDeser);
        registerDeserializer(edu.uga.cs.lsdis.sawsdl.Operation.class,
                Constants.Q_ELEM_ATTR_EXTENSIONS,
                attrExtensionsSerDeser);
        mapExtensionTypes(edu.uga.cs.lsdis.sawsdl.Operation.class,
                Constants.Q_ELEM_ATTR_EXTENSIONS,
                AttrExtensionsImpl.class);

          registerSerializer(Operation.class,
                Constants.Q_ELEM_ATTR_EXTENSIONS,
                attrExtensionsSerDeser);
        registerDeserializer(Operation.class,
                Constants.Q_ELEM_ATTR_EXTENSIONS,
                attrExtensionsSerDeser);
        mapExtensionTypes(Operation.class,
                Constants.Q_ELEM_ATTR_EXTENSIONS,
                AttrExtensionsImpl.class);

        // register the attribute type - all the interfaces that implement the
        // javax.wsdl.extensions.AttributeExtensible should be listed here
        registerExtensionAttributeType(PortType.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(Part.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(Definition.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(Message.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(Binding.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(Port.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(Service.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(Input.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(Output.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(Fault.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(BindingInput.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(BindingOutput.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(BindingFault.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);
        registerExtensionAttributeType(BindingOperation.class,
                Constants.Q_ATTR_MODELREF,
                AttributeExtensible.LIST_OF_STRINGS_TYPE);

    }
}
