/*
 * (c) Copyright IBM Corp 2004, 2005 
 */

package edu.uga.cs.lsdis.sawsdl.impl.schema;

import java.util.Arrays;
import java.util.List;

/**
 * Constants used for handling XML Schemas
 * 
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public class SchemaConstants extends com.ibm.wsdl.extensions.schema.SchemaConstants {

    //Schema attribute names
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_REF = "ref";
    public static final String ATTR_BASE = "base";

    //Schema element names
    public static final String ELEM_ELEMENT = "element";
    public static final String ELEM_SIMPLETYPE = "simpleType";
    public static final String ELEM_COMPLEXTYPE = "complexType";
    public static final String ELEM_ALL = "all";
    public static final String ELEM_SEQUENCE = "sequence";
    public static final String ELEM_CHOICE = "choice";
    public static final String ELEM_COMPLEXCONTENT = "complexContent";
    public static final String ELEM_RESTRICTION = "restriction";
    public static final String ELEM_EXTENSION = "extension";
    public static final String ELEM_GROUP = "group";

    public static final String PREFIX_DEFAULT_SCHEMA ="xsd";
    
    //Schema uri
    public static final List XSD_STR_LIST = Arrays.asList(new String[]
        {NS_URI_XSD_1999, NS_URI_XSD_2000, NS_URI_XSD_2001});


}
