package edu.uga.cs.lsdis.sawsdl.impl.util;

import edu.uga.cs.lsdis.sawsdl.Definition;
import edu.uga.cs.lsdis.sawsdl.ModelReference;
import edu.uga.cs.lsdis.sawsdl.ModelReferenceExtensible;
import edu.uga.cs.lsdis.sawsdl.WSDLSException;
import edu.uga.cs.lsdis.sawsdl.impl.ModelReferenceImpl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * This is a collection of utility methods that operate on 
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public class ModelRefUtil {

    /**
     * Set the value of this modelReference by parsing the formatted string.
     * @param modelReferenceAsString The formatted string
     * @param def WSDLS definition
     * @throws java.net.URISyntaxException
     * @throws edu.uga.cs.lsdis.sawsdl.WSDLSException
     */
    public static void valueOf(ModelReferenceImpl modelRef,
                        String modelReferenceAsString,
                        Definition def) throws URISyntaxException, WSDLSException {



    }




     public static ModelReference
                         getSingleModelReferencesFromString(String modelrefsAsString,
                                                      Definition def) throws URISyntaxException{
         ModelReferenceImpl modelReference = new ModelReferenceImpl();
         modelReference.setURI(new URI(modelrefsAsString));
         return modelReference;
    }


    public static String[] splitString(String modelRefString){
        return  modelRefString.trim().split("\\s+");
    }


    /**
     * @param modelReferenceString
     * @param def
     * @param op
     * @return  a list of model references
     * @throws URISyntaxException
     * @throws WSDLSException
     */
     public static Set<ModelReference> parseModelReference(String modelReferenceString,
                                                       edu.uga.cs.lsdis.sawsdl.Definition def,
                                                       Object op) throws URISyntaxException, WSDLSException {


        return parseModelReference(ModelRefUtil.splitString(modelReferenceString),def,op);



    }// end method parseModelref
    /**
     * @param def
     * @param op
     * @return a list of model references
     * @throws URISyntaxException
     * @throws WSDLSException
     */
     public static Set<ModelReference> parseModelReference(List modelRefs,
                                                       edu.uga.cs.lsdis.sawsdl.Definition def,
                                                       ModelReferenceExtensible op) throws URISyntaxException, WSDLSException {
        Set<ModelReference> modelReferenceList = new HashSet<ModelReference>();
        ModelReference currentModelReference;
        for (Object modelRef : modelRefs) {
            currentModelReference = ModelRefUtil.getSingleModelReferencesFromString((String)modelRef, def);
            currentModelReference.setParent(op);
            modelReferenceList.add(currentModelReference);
            op.addModelReference(currentModelReference);

        }


        return modelReferenceList;


    }// end method parseModelref


    /**
     * @param def
     * @param op
     * @return a list of model references
     * @throws URISyntaxException
     * @throws WSDLSException
     */
     public static Set<ModelReference> parseModelReference(String[] modelRefs,
                                                       edu.uga.cs.lsdis.sawsdl.Definition def,
                                                       Object op) throws URISyntaxException, WSDLSException {
        Set<ModelReference> modelReferenceList = new HashSet<ModelReference>();
        ModelReference currentModelReference;
        for (String modelRef : modelRefs) {
            currentModelReference = ModelRefUtil.getSingleModelReferencesFromString(modelRef, def);
            currentModelReference.setParent(op);
            modelReferenceList.add(currentModelReference);
            if (op instanceof ModelReferenceExtensible)
                ((ModelReferenceExtensible)op).addModelReference(currentModelReference);

        }


        return modelReferenceList;


    }// end method parseModelref
    
}
