/*
 * (c) Copyright IBM Corp 2002, 2005 
 */

package edu.uga.cs.lsdis.sawsdl.impl.util;

import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.XPathUtils;
import edu.uga.cs.lsdis.sawsdl.Definition;
import edu.uga.cs.lsdis.sawsdl.WSDLSException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import javax.wsdl.WSDLException;
import javax.xml.XMLConstants;
import javax.xml.namespace.QName;

/**
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public class QNameUtils {
    public static boolean matches(QName qname, Node node) {
        return (node != null && qname.equals(newQName(node)));
    }

    public static QName newQName(Node node) {
        if (node != null) {
            return new QName(node.getNamespaceURI(), node.getLocalName());
        } else {
            return new QName(null, null);
        }
    }

    public static QName getQName(String prefixedValue,
                                 Element contextEl)
            throws WSDLSException {
        int index = prefixedValue.indexOf(':');
        String prefix = (index != -1)
                ? prefixedValue.substring(0, index)
                : null;
        String localPart = prefixedValue.substring(index + 1);
        String namespaceURI = DOMUtils.getNamespaceURIFromPrefix(contextEl, prefix);

        if (namespaceURI != null)
            return new QName(namespaceURI, localPart);
        else {
            String faultCode = (prefix == null)
                    ? WSDLException.NO_PREFIX_SPECIFIED
                    : WSDLException.UNBOUND_PREFIX;

            WSDLSException wsdlExc = new WSDLSException(faultCode,
                    "Unable to determine " +
                            "namespace of '" +
                            prefixedValue + "'.");

            wsdlExc.setLocation(XPathUtils.getXPathExprFromNode(contextEl));

            throw wsdlExc;
        }
    }

    /**
     * Parse a string, return a QName.
     * The String can be only in the form of "{namespace}localpart"
     *
     * @param qNameAsString
     * @return A QName by parsing the given string.
     */
    public static QName generateQName(String qNameAsString) {
        return generateQName(qNameAsString, null);
    }

    /**
     * Parse a string, return a QName.
     * The String may be in the form of "prefix:localpart" or "{namespace}localpart"
     *
     * @param qNameAsString
     * @param wsdlDef       Wsdl definition for the purpose of getting URI from prefix, and vice versa.
     * @return A QName by paring the given string.
     */
    public static QName generateQName(String qNameAsString, Definition wsdlDef) {
        String nsURI = null;
        String prefix = null;
        String localPart = null;

        if (qNameAsString == null) {
            throw new IllegalArgumentException("cannot create QName from \"null\" or \"\" String");
        }

        if (qNameAsString.charAt(0) == '{') {    //namespace + localpart
            int endOfNamespaceURI = qNameAsString.indexOf('}');
            if (endOfNamespaceURI == -1) {
                throw new IllegalArgumentException(
                        "cannot create QName from \""
                                + qNameAsString
                                + "\", missing closing \"}\"");
            } else {
                nsURI = qNameAsString.substring(1, endOfNamespaceURI);
                //get prefix from wsdls definition
                if (wsdlDef != null)
                    prefix = wsdlDef.getPrefix(nsURI);
                localPart = qNameAsString.substring(endOfNamespaceURI + 1);
                return new QName(nsURI, localPart, nsURI);
            }

        } else {
            int endOfPrefix = qNameAsString.indexOf(':');    //try prefix

            if (endOfPrefix == -1) {        //localpart only, use tagetNamespace from wsdls definition
                if (wsdlDef != null)
                    nsURI = wsdlDef.getTargetNamespace();
                else
                    nsURI = XMLConstants.NULL_NS_URI;
                return new QName(nsURI, qNameAsString);
            } else if (wsdlDef != null) {        //prefix + localpart
                prefix = qNameAsString.substring(1, endOfPrefix);
                nsURI = wsdlDef.getNamespace(prefix);
                localPart = qNameAsString.substring(endOfPrefix + 1);
                return new QName(nsURI, localPart, nsURI);
            } else
                throw new IllegalArgumentException(
                        "cannot create QName from \""
                                + qNameAsString
                                + "\", no URI and no wsdl definition is given");
        }
    }
}