/*
 * Created on Apr 10, 2005
 *
 */
package edu.uga.cs.lsdis.sawsdl.impl.util;

import edu.uga.cs.lsdis.sawsdl.impl.Constants;
import edu.uga.cs.lsdis.sawsdl.impl.schema.SchemaConstants;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Element;

import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This file is a collection of utilities which find the location of a XML/XSD Element by using the given path.
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 *
 */

public class SchemaUtils {

     private static Map<String,String> defaultNamespaceMap;
    
     static{
         defaultNamespaceMap = new HashMap<String,String>();
         defaultNamespaceMap.put(SchemaConstants.PREFIX_DEFAULT_SCHEMA,
                          SchemaConstants.NS_URI_XSD_2001);
         defaultNamespaceMap.put(Constants.PREFIX_SAWSDL,
                                   Constants.NS_URI_SAWSDL);

     }
    /**
     *
     * @param startElement
     * @param path
     * @param s
     * @return the corresponding element
     */
     public static Element findXSDElement(Element startElement, String path,Schema s){
        return findXSDElement(startElement,path,s,defaultNamespaceMap);
     }


     /**
     *
     * @param startElement
     * @param path
     * @param s
     * @return the corresponding element
     */
     public static Element findXSDElement(Element startElement, String path,Schema s,Map namespaceMap){

        try {
            if (namespaceMap== null || namespaceMap.isEmpty()){
                namespaceMap = defaultNamespaceMap;
            }

            NamespaceContext nsContext = new SimpleNamespaceContext(namespaceMap);
            //create a jaxen Xpath reader for the schema
            DOMXPath xpath = new DOMXPath(path);
            xpath.setNamespaceContext(nsContext);
            if (startElement==null){
                startElement = s.getElement();
            }

            return (Element)xpath.selectSingleNode(startElement);
        } catch (JaxenException e) {
            throw new RuntimeException(e);
        }

     }

    /**
     * A utility method that allows to extract a modified set of schema objects 
     * @return   the list of schemas
     */
     public static List<edu.uga.cs.lsdis.sawsdl.extensions.schema.Schema> getSchemas(Types types){
        List <edu.uga.cs.lsdis.sawsdl.extensions.schema.Schema> returnList =
                new ArrayList<edu.uga.cs.lsdis.sawsdl.extensions.schema.Schema>();
        List extensibilityElements = types.getExtensibilityElements();
        for (Object extensibilityElement : extensibilityElements) {
            if (extensibilityElement instanceof edu.uga.cs.lsdis.sawsdl.extensions.schema.Schema){
                 returnList.add((edu.uga.cs.lsdis.sawsdl.extensions.schema.Schema)extensibilityElement);
            }
        }

        return  returnList;
     }
}
