/*
 * (c) 
 */

package edu.uga.cs.lsdis.sawsdl.impl.xml;

import com.ibm.wsdl.util.xml.DOMUtils;
import edu.uga.cs.lsdis.sawsdl.Part;
import edu.uga.cs.lsdis.sawsdl.WSDLSException;
import edu.uga.cs.lsdis.sawsdl.extensions.sawsdl.AttrExtensions;
import edu.uga.cs.lsdis.sawsdl.impl.Constants;
import edu.uga.cs.lsdis.sawsdl.impl.util.ModelRefUtil;
import org.w3c.dom.Element;

import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import java.net.URISyntaxException;
import java.util.List;


/**
 * This class describes a collection of methods
 * that enable conversion of a WSDL-S document (in XML,
 * following the WSDL schema described in the WSDL
 * specification) into a SAWSDL model. Based on the
 * wsdl4j WSDL Reader
 *
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public class WSDLReaderImpl extends com.ibm.wsdl.xml.WSDLReaderImpl {



    /**
     * Parse the part element
     * @param partEl
     * @param def
     * @return the SAWSDL Part object
     * @throws WSDLException
     */
    protected Part parsePart(Element partEl,
                             Definition def)
            throws WSDLException {
        Part semanticPart = (Part) super.parsePart(partEl, def);

        //read modelReference
        String modelReference = DOMUtils.getAttributeNS(partEl,
                Constants.NS_URI_SAWSDL,
                Constants.ATTR_MODELREF);
        if (modelReference != null) {
            try {
                ModelRefUtil.parseModelReference(modelReference,
                        (edu.uga.cs.lsdis.sawsdl.Definition) def, semanticPart);
            } catch (URISyntaxException e) {
                throw new WSDLSException(WSDLException.PARSER_ERROR,
                        "failure parsing model reference in Message Part",e);
            }
        }
        return semanticPart;
    }


    /**
     * The point being that we still might have to support wsdls and hence we want to see if we can use this operation with an internal
     * flag indicating if the parser is being used in the context of WSDLS or SAWSDL.
     *
     * @param opEl
     * @param portType
     * @param def
     * @return the SAWSDL Operation object
     * @throws WSDLSException
     */
    protected Operation parseOperation(Element opEl,
                                       PortType portType,
                                       Definition def)
            throws WSDLException {
        edu.uga.cs.lsdis.sawsdl.Operation op =
                (edu.uga.cs.lsdis.sawsdl.Operation) super.parseOperation(opEl, portType, def);
        // for the operations the treatment is different
        String modelReference = getOperationModelReference(op);
        if (modelReference != null) {
            try {
                ModelRefUtil.parseModelReference(modelReference,
                        (edu.uga.cs.lsdis.sawsdl.Definition) def, op);
            } catch (URISyntaxException e) {
                throw new WSDLSException(WSDLException.PARSER_ERROR,
                        "failure parsing model reference in Operation",e);
            }

        }
        return op;
    }

    /**
     * Go though the extensibility elements and see whether we can find an extensibility
     * element of type AttrExtensions
     * @param op
     * @return the string value of the model reference, null otherwise
     */
    private String getOperationModelReference(edu.uga.cs.lsdis.sawsdl.Operation op) {
        List extensibilityElements = op.getExtensibilityElements();
        for (Object extensibilityElement : extensibilityElements) {
            if (extensibilityElement instanceof AttrExtensions){
                AttrExtensions attrExtensions = (AttrExtensions) extensibilityElement;
                return attrExtensions.getModelRefStringValue();
            }

        }
        return null;
    }

    /**
     * Overriden parse Porttype operation
     * @param portTypeEl
     * @param def
     * @return the SAWSDL Porttype object
     * @throws WSDLException
     */
    protected PortType parsePortType(Element portTypeEl, Definition def) throws WSDLException {
        edu.uga.cs.lsdis.sawsdl.PortType portType =
                (edu.uga.cs.lsdis.sawsdl.PortType) super.parsePortType(portTypeEl, def);



        List modelReference = ((List) portType.getExtensionAttribute(Constants.Q_ATTR_MODELREF));

        if (modelReference != null && !modelReference.isEmpty()) {
            try {
                ModelRefUtil.parseModelReference(modelReference,
                        (edu.uga.cs.lsdis.sawsdl.Definition) def, portType);
            } catch (URISyntaxException e) {
                throw new WSDLSException(WSDLException.PARSER_ERROR,
                        "failure parsing model reference in Porttype",e);
            }

        }
        return portType;
    }


}
