/*
 * (c) 
 */

package edu.uga.cs.lsdis.sawsdl.impl.xml;

import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import edu.uga.cs.lsdis.sawsdl.Operation;
import edu.uga.cs.lsdis.sawsdl.PortType;
import edu.uga.cs.lsdis.sawsdl.impl.Constants;

import javax.wsdl.Definition;
import javax.wsdl.OperationType;
import javax.wsdl.WSDLException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * This class describes a collection of methods
 * that allow a WSDL-S model to be written to a writer
 * in an XML format that follows the WSDL schema.
 *
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public class WSDLWriterImpl extends com.ibm.wsdl.xml.WSDLWriterImpl {


	
    @Override
	protected void printDefinition(Definition def, PrintWriter pw)
			throws WSDLException {
    	//add the sawsdl prefix.
    	def.addNamespace(Constants.PREFIX_SAWSDL, Constants.NS_URI_SAWSDL);
    	
    	super.printDefinition(def, pw);
	}




	/**
     *
     * @param portTypes
     * @param def
     * @param pw
     * @throws WSDLException
     */
    protected void printPortTypes(Map portTypes,
                                  Definition def,
                                  PrintWriter pw)
            throws WSDLException {
    	 super.printPortTypes(portTypes,def,pw);
    }




    protected void printOperations(List operations,
                                   Definition def,
                                   PrintWriter pw)
            throws WSDLException{

        try {
            if (operations != null) {
                String tagName =
                        DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL,
                                Constants.ELEM_OPERATION,
                                def);
                Iterator operationIterator = operations.iterator();

                while (operationIterator.hasNext()) {
                    Operation operation = (Operation) operationIterator.next();

                    if (!operation.isUndefined()) {
                        pw.print("    <" + tagName);

                        DOMUtils.printAttribute(Constants.ATTR_NAME,
                                operation.getName(),
                                pw);

                        // model references DO NOT get printed here as attributes!!!!!!

                        DOMUtils.printAttribute(Constants.ATTR_PARAMETER_ORDER,
                                StringUtils.getNMTokens(operation.getParameterOrdering()),
                                pw);
                       /////////////////////////////////////////////////////////////////

                        pw.println('>');

                        printDocumentation(operation.getDocumentationElement(),def, pw);

                        OperationType operationType = operation.getStyle();

                        if (operationType == OperationType.ONE_WAY) {
                            printInput(operation.getInput(), def, pw);
                        } else if (operationType == OperationType.SOLICIT_RESPONSE) {
                            printOutput(operation.getOutput(), def, pw);
                            printInput(operation.getInput(), def, pw);
                        } else if (operationType == OperationType.NOTIFICATION) {
                            printOutput(operation.getOutput(), def, pw);
                        } else {
                            // Must be OperationType.REQUEST_RESPONSE.
                            printInput(operation.getInput(), def, pw);
                            printOutput(operation.getOutput(), def, pw);
                        }

                        printFaults(operation.getFaults(), def, pw);

                        List extElements = operation.getExtensibilityElements();

                        printExtensibilityElements(Operation.class, extElements, def, pw);

                        pw.println("</" + tagName + '>');
                    }
                }
            }
        } catch (Exception e) {
            throw new WSDLException("",e.getMessage(),e);
        }
    }



}
