package edu.uga.cs.lsdis.sawsdl.util;

import edu.uga.cs.lsdis.sawsdl.Definition;

import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import java.io.File;

/**
 A utility class for the users to easily create and modify SAWSDL object structures
 This includes methods to get all elements with model references, all schema elements
 with model references and so on.
 */
public class SAWSDLUtility {

    /**
     * A utility method to get the sawsdl.Definition direclty. This method
     * Takes care of creating the factories
     * @param f - the file to load the definition from
     * @param factory - The WSDL factory object
     * @return Definition he definition object
     * @throws WSDLException in case of any exceptional behavior
     */
    public static Definition getDefinitionFromFile(File f, WSDLFactory factory) throws WSDLException {
        WSDLReader wsdlReader = factory.newWSDLReader();
        String wsdlURI = f.toURI().toString();
        return (Definition)wsdlReader.readWSDL(wsdlURI);
    }

     /**
     * A utility method to get the sawsdl.Definition direclty. This method
     * Takes care of creating the factory assuming the system properties has been set
     * priorly
     * @param f - the file to load the definition from
     * @return Definition he definition object
     * @throws WSDLException in case of any exceptional behavior
     */
    public static Definition getDefinitionFromFile(File f) throws WSDLException {
        WSDLFactory fac = WSDLFactory.newInstance();
        return getDefinitionFromFile(f,fac);
    }

}
