/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr;

import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.jcr.JCRImapConstants;
import org.apache.james.mailbox.jcr.JCRMailboxSessionMapperFactory;
import org.apache.james.mailbox.jcr.JCRMessageManager;
import org.apache.james.mailbox.jcr.mail.model.JCRMailbox;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxEventDispatcher;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRMailboxManager
extends StoreMailboxManager<String>
implements JCRImapConstants {
    private final Logger logger = LoggerFactory.getLogger(JCRMailboxManager.class);

    public JCRMailboxManager(JCRMailboxSessionMapperFactory mapperFactory, Authenticator authenticator) {
        this(mapperFactory, authenticator, (MailboxPathLocker)new JVMMailboxPathLocker());
    }

    public JCRMailboxManager(JCRMailboxSessionMapperFactory mapperFactory, Authenticator authenticator, MailboxPathLocker locker) {
        super((MailboxSessionMapperFactory)mapperFactory, authenticator, locker);
    }

    protected StoreMessageManager<String> createMessageManager(Mailbox<String> mailboxEntity, MailboxSession session) throws MailboxException {
        return new JCRMessageManager((MailboxSessionMapperFactory<String>)this.getMapperFactory(), (MessageSearchIndex<String>)this.getMessageSearchIndex(), (MailboxEventDispatcher<String>)this.getEventDispatcher(), (JCRMailbox)mailboxEntity, this.logger, this.getDelimiter());
    }

    protected Mailbox<String> doCreateMailbox(MailboxPath path, MailboxSession session) throws MailboxException {
        return new JCRMailbox(path, this.randomUidValidity(), this.logger);
    }
}

