/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr;

import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionException;
import org.apache.james.mailbox.jcr.MailboxSessionJCRRepository;
import org.apache.james.mailbox.jcr.mail.JCRMailboxMapper;
import org.apache.james.mailbox.jcr.mail.JCRMessageMapper;
import org.apache.james.mailbox.jcr.user.JCRSubscriptionMapper;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class JCRMailboxSessionMapperFactory
extends MailboxSessionMapperFactory<String> {
    private final MailboxSessionJCRRepository repository;
    private static final int DEFAULT_SCALING = 2;
    private final int scaling;
    private int messageScaling;
    private UidProvider<String> uidProvider;
    private ModSeqProvider<String> modSeqProvider;

    public JCRMailboxSessionMapperFactory(MailboxSessionJCRRepository repository, UidProvider<String> uidProvider, ModSeqProvider<String> modSeqProvider) {
        this(repository, uidProvider, modSeqProvider, 2, 3);
    }

    public JCRMailboxSessionMapperFactory(MailboxSessionJCRRepository repository, UidProvider<String> uidProvider, ModSeqProvider<String> modSeqProvider, int scaling, int messageScaling) {
        this.repository = repository;
        this.scaling = scaling;
        this.messageScaling = messageScaling;
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
    }

    public MailboxMapper<String> createMailboxMapper(MailboxSession session) throws MailboxException {
        JCRMailboxMapper mapper = new JCRMailboxMapper(this.repository, session, this.scaling);
        return mapper;
    }

    public MessageMapper<String> createMessageMapper(MailboxSession session) throws MailboxException {
        JCRMessageMapper messageMapper = new JCRMessageMapper(this.repository, session, this.uidProvider, this.modSeqProvider, this.messageScaling);
        return messageMapper;
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession session) throws SubscriptionException {
        JCRSubscriptionMapper mapper = new JCRSubscriptionMapper(this.repository, session, 2);
        return mapper;
    }

    public MailboxSessionJCRRepository getRepository() {
        return this.repository;
    }
}

