/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr;

import java.util.Date;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.jcr.mail.model.JCRMailbox;
import org.apache.james.mailbox.jcr.mail.model.JCRMessage;
import org.apache.james.mailbox.store.MailboxEventDispatcher;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.slf4j.Logger;

public class JCRMessageManager
extends StoreMessageManager<String> {
    private final Logger log;

    public JCRMessageManager(MailboxSessionMapperFactory<String> mapperFactory, MessageSearchIndex<String> index, MailboxEventDispatcher<String> dispatcher, JCRMailbox mailbox, Logger log, char delimiter) throws MailboxException {
        super(mapperFactory, index, dispatcher, (Mailbox)mailbox);
        this.log = log;
    }

    protected Message<String> createMessage(Date internalDate, int size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder) throws MailboxException {
        JCRMessage message = new JCRMessage((String)this.getMailboxEntity().getMailboxId(), internalDate, size, flags, content, bodyStartOctet, propertyBuilder, this.log);
        return message;
    }

    protected Flags getPermanentFlags(MailboxSession session) {
        Flags perm = super.getPermanentFlags(session);
        perm.add(Flags.Flag.USER);
        return perm;
    }
}

