/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.james.mailbox.jcr.JCRImapConstants;

public class JCRUtils
implements JCRImapConstants {
    public static void registerCnd(Repository repository, String workspace, String username, String password) {
        try {
            Session session;
            if (username == null) {
                session = repository.login(workspace);
            } else {
                char[] pass = password == null ? new char[]{} : password.toCharArray();
                session = repository.login((Credentials)new SimpleCredentials(username, pass), workspace);
            }
            JCRUtils.registerCnd(session);
            session.logout();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register cnd file", e);
        }
    }

    public static void registerCnd(Session session) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/apache/james/mailbox/jcr/imap.cnd");
        try {
            CndImporter.registerNodeTypes((Reader)new InputStreamReader(is), (Session)session);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register cnd file", e);
        }
    }
}

