/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr;

import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.james.mailbox.MailboxSession;

public class MailboxSessionJCRRepository {
    private static final String JCR_SESSION = "JCR_SESSION";
    private Repository repository;
    private String workspace;

    public MailboxSessionJCRRepository(Repository repository, String workspace) {
        this.repository = repository;
        this.workspace = workspace;
    }

    public Session login(MailboxSession session) throws RepositoryException {
        MailboxSession.User user = session.getUser();
        String username = user.getUserName();
        String password = user.getPassword();
        char[] pass = null;
        if (password != null) {
            pass = password.toCharArray();
        }
        return this.login(session, username, pass);
    }

    protected Session login(MailboxSession mSession, String username, char[] pass) throws RepositoryException {
        Session session = (Session)mSession.getAttributes().get(JCR_SESSION);
        if (session == null) {
            session = this.repository.login((Credentials)new SimpleCredentials(username, pass), this.workspace);
            mSession.getAttributes().put(JCR_SESSION, session);
        }
        return session;
    }

    public void logout(MailboxSession mSession) {
        if (mSession == null) {
            return;
        }
        Session session = (Session)mSession.getAttributes().remove(JCR_SESSION);
        if (session != null) {
            if (session.isLive()) {
                session.logout();
            }
            session = null;
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }
}

