/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr.mail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageMetaData;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.jcr.JCRImapConstants;
import org.apache.james.mailbox.jcr.MailboxSessionJCRRepository;
import org.apache.james.mailbox.jcr.mail.model.JCRMessage;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.mail.AbstractMessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;

public class JCRMessageMapper
extends AbstractMessageMapper<String>
implements JCRImapConstants {
    public static final int MESSAGE_SCALE_NONE = 0;
    public static final int MESSAGE_SCALE_YEAR = 1;
    public static final int MESSAGE_SCALE_MONTH = 2;
    public static final int MESSAGE_SCALE_DAY = 3;
    public static final int MESSAGE_SCALE_HOUR = 4;
    public static final int MESSAGE_SCALE_MINUTE = 5;
    private final int scaleType;
    private final MailboxSessionJCRRepository repository;

    public JCRMessageMapper(MailboxSessionJCRRepository repository, MailboxSession mSession, UidProvider<String> uidProvider, ModSeqProvider<String> modSeqProvider, int scaleType) {
        super(mSession, uidProvider, modSeqProvider);
        this.repository = repository;
        this.scaleType = scaleType;
    }

    public JCRMessageMapper(MailboxSessionJCRRepository repos, MailboxSession session, UidProvider<String> uidProvider, ModSeqProvider<String> modSeqProvider) {
        this(repos, session, uidProvider, modSeqProvider, 3);
    }

    protected Session getSession() throws RepositoryException {
        return this.repository.login(this.mailboxSession);
    }

    protected void begin() throws MailboxException {
        try {
            this.getSession().refresh(true);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    protected void commit() throws MailboxException {
        try {
            if (this.getSession().hasPendingChanges()) {
                this.getSession().save();
            }
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to commit", (Exception)((Object)e));
        }
    }

    protected void rollback() throws MailboxException {
        try {
            this.getSession().refresh(false);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    private String getMailboxPath(Mailbox<String> mailbox) throws ItemNotFoundException, RepositoryException {
        return ISO9075.encodePath((String)this.getSession().getNodeByIdentifier((String)mailbox.getMailboxId()).getPath());
    }

    public long countMessagesInMailbox(Mailbox<String> mailbox) throws MailboxException {
        try {
            String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message) order by @" + "jamesMailbox:uid";
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            QueryResult result = manager.createQuery(queryString, "xpath").execute();
            NodeIterator nodes = result.getNodes();
            long count = nodes.getSize();
            if (count == -1L) {
                count = 0L;
                while (nodes.hasNext()) {
                    nodes.nextNode();
                    ++count;
                }
            }
            return count;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to count messages in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public long countUnseenMessagesInMailbox(Mailbox<String> mailbox) throws MailboxException {
        try {
            String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:seen" + "='false'] order by @" + "jamesMailbox:uid";
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            QueryResult result = manager.createQuery(queryString, "xpath").execute();
            NodeIterator nodes = result.getNodes();
            long count = nodes.getSize();
            if (count == -1L) {
                count = 0L;
                while (nodes.hasNext()) {
                    nodes.nextNode();
                    ++count;
                }
            }
            return count;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to count unseen messages in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public void delete(Mailbox<String> mailbox, Message<String> message) throws MailboxException {
        JCRMessage membership = (JCRMessage)message;
        if (membership.isPersistent()) {
            try {
                this.getSession().getNodeByIdentifier(membership.getId()).remove();
            }
            catch (RepositoryException e) {
                throw new MailboxException("Unable to delete message " + message + " in mailbox " + mailbox, (Exception)((Object)e));
            }
        }
    }

    public void findInMailbox(Mailbox<String> mailbox, MessageRange set, MessageMapper.FetchType fType, MessageMapper.MessageCallback<String> callback) throws MailboxException {
        try {
            List<Message<String>> results;
            long from = set.getUidFrom();
            long to = set.getUidTo();
            int batchSize = set.getBatchSize();
            MessageRange.Type type = set.getType();
            do {
                switch (type) {
                    default: {
                        results = this.findMessagesInMailbox(mailbox, batchSize);
                        break;
                    }
                    case FROM: {
                        results = this.findMessagesInMailboxAfterUID(mailbox, from, batchSize);
                        break;
                    }
                    case ONE: {
                        results = this.findMessageInMailboxWithUID(mailbox, from);
                        break;
                    }
                    case RANGE: {
                        results = this.findMessagesInMailboxBetweenUIDs(mailbox, from, to, batchSize);
                    }
                }
                if (results.size() <= 0) continue;
                callback.onMessages(results);
                from = results.get(results.size() - 1).getUid() + 1L;
            } while (results.size() > 0 && batchSize > 0);
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to search MessageRange " + set + " in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    private List<Message<String>> findMessagesInMailboxAfterUID(Mailbox<String> mailbox, long uid, int batchSize) throws RepositoryException {
        ArrayList<Message<String>> list = new ArrayList<Message<String>>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:uid" + ">=" + uid + "] order by @" + "jamesMailbox:uid";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        Query query = manager.createQuery(queryString, "xpath");
        if (batchSize > 0) {
            query.setLimit((long)batchSize);
        }
        QueryResult result = query.execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            list.add((Message<String>)new JCRMessage(iterator.nextNode(), this.mailboxSession.getLog()));
        }
        return list;
    }

    private List<Message<String>> findMessageInMailboxWithUID(Mailbox<String> mailbox, long uid) throws RepositoryException {
        ArrayList<Message<String>> list = new ArrayList<Message<String>>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:uid" + "=" + uid + "]";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        Query query = manager.createQuery(queryString, "xpath");
        query.setLimit(1L);
        QueryResult result = query.execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            list.add((Message<String>)new JCRMessage(iterator.nextNode(), this.mailboxSession.getLog()));
        }
        return list;
    }

    private List<Message<String>> findMessagesInMailboxBetweenUIDs(Mailbox<String> mailbox, long from, long to, int batchSize) throws RepositoryException {
        ArrayList<Message<String>> list = new ArrayList<Message<String>>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:uid" + ">=" + from + " and @" + "jamesMailbox:uid" + "<=" + to + "] order by @" + "jamesMailbox:uid";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        Query query = manager.createQuery(queryString, "xpath");
        if (batchSize > 0) {
            query.setLimit((long)batchSize);
        }
        QueryResult result = query.execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            list.add((Message<String>)new JCRMessage(iterator.nextNode(), this.mailboxSession.getLog()));
        }
        return list;
    }

    private List<Message<String>> findMessagesInMailbox(Mailbox<String> mailbox, int batchSize) throws RepositoryException {
        ArrayList<Message<String>> list = new ArrayList<Message<String>>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message) order by @" + "jamesMailbox:uid";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        Query query = manager.createQuery(queryString, "xpath");
        if (batchSize > 0) {
            query.setLimit((long)batchSize);
        }
        QueryResult result = query.execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            list.add((Message<String>)new JCRMessage(iterator.nextNode(), this.mailboxSession.getLog()));
        }
        return list;
    }

    private List<Message<String>> findDeletedMessagesInMailboxAfterUID(Mailbox<String> mailbox, long uid) throws RepositoryException {
        ArrayList<Message<String>> list = new ArrayList<Message<String>>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:uid" + ">=" + uid + " and @" + "jamesMailbox:deleted" + "='true'] order by @" + "jamesMailbox:uid";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        QueryResult result = manager.createQuery(queryString, "xpath").execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            list.add((Message<String>)new JCRMessage(iterator.nextNode(), this.mailboxSession.getLog()));
        }
        return list;
    }

    private List<Message<String>> findDeletedMessageInMailboxWithUID(Mailbox<String> mailbox, long uid) throws RepositoryException {
        ArrayList<Message<String>> list = new ArrayList<Message<String>>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:uid" + "=" + uid + " and @" + "jamesMailbox:deleted" + "='true']";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        Query query = manager.createQuery(queryString, "xpath");
        query.setLimit(1L);
        QueryResult result = query.execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            JCRMessage member = new JCRMessage(iterator.nextNode(), this.mailboxSession.getLog());
            list.add((Message<String>)member);
        }
        return list;
    }

    private List<Message<String>> findDeletedMessagesInMailboxBetweenUIDs(Mailbox<String> mailbox, long from, long to) throws RepositoryException {
        ArrayList<Message<String>> list = new ArrayList<Message<String>>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:uid" + ">=" + from + " and @" + "jamesMailbox:uid" + "<=" + to + " and @" + "jamesMailbox:deleted" + "='true'] order by @" + "jamesMailbox:uid";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        QueryResult result = manager.createQuery(queryString, "xpath").execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            list.add((Message<String>)new JCRMessage(iterator.nextNode(), this.mailboxSession.getLog()));
        }
        return list;
    }

    private List<Message<String>> findDeletedMessagesInMailbox(Mailbox<String> mailbox) throws RepositoryException {
        ArrayList<Message<String>> list = new ArrayList<Message<String>>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:deleted" + "='true'] order by @" + "jamesMailbox:uid";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        QueryResult result = manager.createQuery(queryString, "xpath").execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            JCRMessage member = new JCRMessage(iterator.nextNode(), this.mailboxSession.getLog());
            list.add((Message<String>)member);
        }
        return list;
    }

    public List<Long> findRecentMessageUidsInMailbox(Mailbox<String> mailbox) throws MailboxException {
        try {
            ArrayList<Long> list = new ArrayList<Long>();
            String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:recent" + "='true'] order by @" + "jamesMailbox:uid";
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            Query query = manager.createQuery(queryString, "xpath");
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            while (iterator.hasNext()) {
                list.add(new JCRMessage(iterator.nextNode(), this.mailboxSession.getLog()).getUid());
            }
            return list;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to search recent messages in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public Long findFirstUnseenMessageUid(Mailbox<String> mailbox) throws MailboxException {
        try {
            String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:seen" + "='false'] order by @" + "jamesMailbox:uid";
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            Query query = manager.createQuery(queryString, "xpath");
            query.setLimit(1L);
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            if (iterator.hasNext()) {
                return new JCRMessage(iterator.nextNode(), this.mailboxSession.getLog()).getUid();
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to find first unseen message in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    private String convertIntToString(int value) {
        if (value <= 9) {
            return "0" + String.valueOf(value);
        }
        return String.valueOf(value);
    }

    public void endRequest() {
        this.repository.logout(this.mailboxSession);
    }

    protected MessageMetaData copy(Mailbox<String> mailbox, long uid, long modSeq, Message<String> original) throws MailboxException {
        try {
            String newMessagePath = this.getSession().getNodeByIdentifier((String)mailbox.getMailboxId()).getPath() + "/" + String.valueOf(uid);
            this.getSession().getWorkspace().copy(((JCRMessage)original).getNode().getPath(), this.getSession().getNodeByIdentifier((String)mailbox.getMailboxId()).getPath() + "/" + String.valueOf(uid));
            Node node = this.getSession().getNode(newMessagePath);
            node.setProperty("jamesMailbox:mailboxUUID", (String)mailbox.getMailboxId());
            node.setProperty("jamesMailbox:uid", uid);
            node.setProperty("jamesMailbox:modSeq", modSeq);
            node.setProperty("jamesMailbox:recent", true);
            return new SimpleMessageMetaData((Message)new JCRMessage(node, this.mailboxSession.getLog()));
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to copy message " + original + " in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    protected MessageMetaData save(Mailbox<String> mailbox, Message<String> message) throws MailboxException {
        JCRMessage membership = (JCRMessage)message;
        try {
            Node messageNode = null;
            if (membership.isPersistent()) {
                messageNode = this.getSession().getNodeByIdentifier(membership.getId());
            }
            if (messageNode == null) {
                Node mailboxNode;
                Date date = message.getInternalDate();
                if (date == null) {
                    date = new Date();
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                String year = this.convertIntToString(cal.get(1));
                String month = this.convertIntToString(cal.get(2) + 1);
                String day = this.convertIntToString(cal.get(5));
                String hour = this.convertIntToString(cal.get(11));
                String min = this.convertIntToString(cal.get(12));
                Node node = mailboxNode = this.getSession().getNodeByIdentifier((String)mailbox.getMailboxId());
                if (this.scaleType > 0 && this.scaleType >= 1) {
                    node = JcrUtils.getOrAddFolder((Node)node, (String)year);
                    if (this.scaleType >= 2) {
                        node = JcrUtils.getOrAddFolder((Node)node, (String)month);
                        if (this.scaleType >= 3) {
                            node = JcrUtils.getOrAddFolder((Node)node, (String)day);
                            if (this.scaleType >= 4) {
                                node = JcrUtils.getOrAddFolder((Node)node, (String)hour);
                                if (this.scaleType >= 5) {
                                    node = JcrUtils.getOrAddFolder((Node)node, (String)min);
                                }
                            }
                        }
                    }
                }
                long uid = membership.getUid();
                messageNode = mailboxNode.addNode(String.valueOf(uid), "nt:file");
                messageNode.addMixin("jamesMailbox:message");
                try {
                    membership.merge(messageNode);
                }
                catch (IOException e) {
                    throw new RepositoryException("Unable to merge message in to tree", (Throwable)e);
                }
            } else {
                membership.merge(messageNode);
            }
            return new SimpleMessageMetaData((Message)membership);
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to save message " + message + " in mailbox " + mailbox, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MailboxException("Unable to save message " + message + " in mailbox " + mailbox, (Exception)e);
        }
    }

    public Map<Long, MessageMetaData> expungeMarkedForDeletionInMailbox(Mailbox<String> mailbox, MessageRange set) throws MailboxException {
        try {
            List<Message<String>> results;
            long from = set.getUidFrom();
            long to = set.getUidTo();
            MessageRange.Type type = set.getType();
            switch (type) {
                default: {
                    results = this.findDeletedMessagesInMailbox(mailbox);
                    break;
                }
                case FROM: {
                    results = this.findDeletedMessagesInMailboxAfterUID(mailbox, from);
                    break;
                }
                case ONE: {
                    results = this.findDeletedMessageInMailboxWithUID(mailbox, from);
                    break;
                }
                case RANGE: {
                    results = this.findDeletedMessagesInMailboxBetweenUIDs(mailbox, from, to);
                }
            }
            HashMap<Long, MessageMetaData> uids = new HashMap<Long, MessageMetaData>();
            for (int i = 0; i < results.size(); ++i) {
                Message<String> m = results.get(i);
                long uid = m.getUid();
                uids.put(uid, (MessageMetaData)new SimpleMessageMetaData(m));
                this.delete(mailbox, m);
            }
            return uids;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to search MessageRange " + set + " in mailbox " + mailbox, (Exception)((Object)e));
        }
    }
}

