/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr.mail;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.jcr.MailboxSessionJCRRepository;
import org.apache.james.mailbox.store.mail.AbstractLockingModSeqProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class JCRModSeqProvider
extends AbstractLockingModSeqProvider<String> {
    private MailboxSessionJCRRepository repository;

    public JCRModSeqProvider(MailboxPathLocker locker, MailboxSessionJCRRepository repository) {
        super(locker);
        this.repository = repository;
    }

    public long highestModSeq(MailboxSession session, Mailbox<String> mailbox) throws MailboxException {
        try {
            Session s = this.repository.login(session);
            Node node = s.getNodeByIdentifier((String)mailbox.getMailboxId());
            return node.getProperty("jamesMailbox:mailboxHighestModSeq").getLong();
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to get highest mod-sequence for mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    protected long lockedNextModSeq(MailboxSession session, Mailbox<String> mailbox) throws MailboxException {
        try {
            Session s = this.repository.login(session);
            Node node = s.getNodeByIdentifier((String)mailbox.getMailboxId());
            long modseq = node.getProperty("jamesMailbox:mailboxHighestModSeq").getLong();
            node.setProperty("jamesMailbox:mailboxHighestModSeq", ++modseq);
            s.save();
            return modseq;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to consume next uid for mailbox " + mailbox, (Exception)((Object)e));
        }
    }
}

