/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr.mail;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.jcr.MailboxSessionJCRRepository;
import org.apache.james.mailbox.store.mail.AbstractLockingUidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class JCRUidProvider
extends AbstractLockingUidProvider<String> {
    private MailboxSessionJCRRepository repository;

    public JCRUidProvider(MailboxPathLocker locker, MailboxSessionJCRRepository repository) {
        super(locker);
        this.repository = repository;
    }

    public long lastUid(MailboxSession mailboxSession, Mailbox<String> mailbox) throws MailboxException {
        try {
            Session s = this.repository.login(mailboxSession);
            Node node = s.getNodeByIdentifier((String)mailbox.getMailboxId());
            return node.getProperty("jamesMailbox:mailboxLastUid").getLong();
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to get last uid for mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    protected long lockedNextUid(MailboxSession session, Mailbox<String> mailbox) throws MailboxException {
        try {
            Session s = this.repository.login(session);
            Node node = s.getNodeByIdentifier((String)mailbox.getMailboxId());
            long uid = node.getProperty("jamesMailbox:mailboxLastUid").getLong();
            node.setProperty("jamesMailbox:mailboxLastUid", ++uid);
            s.save();
            return uid;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to consume next uid for mailbox " + mailbox, (Exception)((Object)e));
        }
    }
}

