/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr.mail.model;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.Text;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.jcr.JCRImapConstants;
import org.apache.james.mailbox.jcr.Persistent;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.slf4j.Logger;

public class JCRMailbox
implements Mailbox<String>,
JCRImapConstants,
Persistent {
    private static final String TAB = " ";
    public static final String USER_PROPERTY = "jamesMailbox:mailboxUser";
    public static final String NAMESPACE_PROPERTY = "jamesMailbox:mailboxNamespace";
    public static final String NAME_PROPERTY = "jamesMailbox:mailboxName";
    public static final String UIDVALIDITY_PROPERTY = "jamesMailbox:mailboxUidValidity";
    public static final String LASTUID_PROPERTY = "jamesMailbox:mailboxLastUid";
    public static final String HIGHESTMODSEQ_PROPERTY = "jamesMailbox:mailboxHighestModSeq";
    private String name;
    private long uidValidity;
    private final Logger logger;
    private Node node;
    private String namespace;
    private String user;
    private long lastKnownUid;
    private long highestKnownModSeq;

    public JCRMailbox(MailboxPath path, long uidValidity, Logger logger) {
        this.name = path.getName();
        this.namespace = path.getNamespace();
        this.user = path.getUser();
        this.uidValidity = uidValidity;
        this.logger = logger;
    }

    public JCRMailbox(Node node, Logger logger) {
        this.node = node;
        this.logger = logger;
    }

    public Logger getLog() {
        return this.logger;
    }

    public String getName() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(NAME_PROPERTY).getString();
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access property jamesMailbox:mailboxName", (Throwable)e);
            }
        }
        return this.name;
    }

    public long getUidValidity() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(UIDVALIDITY_PROPERTY).getLong();
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access property jamesMailbox:mailboxUidValidity", (Throwable)e);
            }
        }
        return this.uidValidity;
    }

    public void setName(String name) {
        if (this.isPersistent()) {
            try {
                this.node.setProperty(NAME_PROPERTY, name);
                this.node.getSession().move(this.node.getPath(), this.node.getParent().getPath() + "/" + Text.escapePath((String)name));
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access property jamesMailbox:mailboxName", (Throwable)e);
            }
        } else {
            this.name = name;
        }
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public boolean isPersistent() {
        return this.node != null;
    }

    @Override
    public void merge(Node node) throws RepositoryException {
        node.setProperty(NAME_PROPERTY, this.getName());
        node.setProperty(UIDVALIDITY_PROPERTY, this.getUidValidity());
        String user = this.getUser();
        if (user == null) {
            user = "";
        }
        node.setProperty(USER_PROPERTY, user);
        node.setProperty(NAMESPACE_PROPERTY, this.getNamespace());
        node.setProperty(HIGHESTMODSEQ_PROPERTY, this.getHighestModSeq());
        node.setProperty(LASTUID_PROPERTY, this.getLastUid());
        this.node = node;
    }

    public String toString() {
        String retValue = "Mailbox ( mailboxUID = " + this.getMailboxId() + TAB + "name = " + this.getName() + TAB + "uidValidity = " + this.getUidValidity() + TAB + " )";
        return retValue;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.getMailboxId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JCRMailbox other = (JCRMailbox)obj;
        return !(this.getMailboxId() != null ? !this.getMailboxId().equals(other.getMailboxId()) : other.getMailboxId() != null);
    }

    public String getMailboxId() {
        if (this.isPersistent()) {
            try {
                return this.node.getIdentifier();
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access property jcr:uuid", (Throwable)e);
            }
        }
        return null;
    }

    public String getNamespace() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(NAMESPACE_PROPERTY).getString();
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access property jamesMailbox:mailboxNamespace", (Throwable)e);
            }
        }
        return this.namespace;
    }

    public String getUser() {
        if (this.isPersistent()) {
            try {
                String user = this.node.getProperty(USER_PROPERTY).getString();
                if (user.trim().length() == 0) {
                    return null;
                }
                return user;
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access property jamesMailbox:mailboxUser", (Throwable)e);
            }
        }
        return this.user;
    }

    public void setNamespace(String namespace) {
        if (this.isPersistent()) {
            try {
                this.node.setProperty(NAMESPACE_PROPERTY, namespace);
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access property jamesMailbox:mailboxNamespace", (Throwable)e);
            }
        } else {
            this.namespace = namespace;
        }
    }

    public void setUser(String user) {
        if (this.isPersistent()) {
            try {
                if (user == null) {
                    user = "";
                }
                this.node.setProperty(USER_PROPERTY, user);
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access property jamesMailbox:mailboxName", (Throwable)e);
            }
        } else {
            this.user = user;
        }
    }

    private long getLastUid() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(LASTUID_PROPERTY).getLong();
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access property jamesMailbox:mailboxLastUid", (Throwable)e);
            }
        }
        return this.lastKnownUid;
    }

    private long getHighestModSeq() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(HIGHESTMODSEQ_PROPERTY).getLong();
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access property jamesMailbox:mailboxHighestModSeq", (Throwable)e);
            }
        }
        return this.highestKnownModSeq;
    }
}

