/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr.mail.model;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.james.mailbox.jcr.JCRImapConstants;
import org.apache.james.mailbox.jcr.Persistent;
import org.apache.james.mailbox.store.mail.model.Property;
import org.slf4j.Logger;

public class JCRProperty
implements JCRImapConstants,
Persistent,
Property {
    private Node node;
    private final Logger logger;
    private String namespace;
    private String localName;
    private String value;
    private int order;
    public static final String NAMESPACE_PROPERTY = "jamesMailbox:propertyNamespace";
    public static final String LOCALNAME_PROPERTY = "jamesMailbox:propertyLocalName";
    public static final String VALUE_PROPERTY = "jamesMailbox:propertyValue";
    public static final String ORDER_PROPERTY = "jamesMailbox:propertyOrder";

    public JCRProperty(Node node, Logger logger) {
        this.node = node;
        this.logger = logger;
    }

    public JCRProperty(String namespace, String localName, String value, Logger logger) {
        this.namespace = namespace;
        this.localName = localName;
        this.value = value;
        this.logger = logger;
    }

    public JCRProperty(Property property, Logger logger) {
        this(property.getNamespace(), property.getLocalName(), property.getValue(), logger);
    }

    public int getOrder() {
        if (this.isPersistent()) {
            try {
                return (int)this.node.getProperty(ORDER_PROPERTY).getLong();
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access Property jamesMailbox:propertyOrder", (Throwable)e);
                return 0;
            }
        }
        return this.order;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    public String getLocalName() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(LOCALNAME_PROPERTY).getString();
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access Property jamesMailbox:propertyLocalName", (Throwable)e);
                return null;
            }
        }
        return this.localName;
    }

    public String getNamespace() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(NAMESPACE_PROPERTY).getString();
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access Property jamesMailbox:propertyNamespace", (Throwable)e);
                return null;
            }
        }
        return this.namespace;
    }

    public String getValue() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(VALUE_PROPERTY).getString();
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to access Property jamesMailbox:propertyValue", (Throwable)e);
                return null;
            }
        }
        return this.value;
    }

    @Override
    public boolean isPersistent() {
        return this.node != null;
    }

    @Override
    public void merge(Node node) throws RepositoryException {
        node.setProperty(NAMESPACE_PROPERTY, this.getNamespace());
        node.setProperty(ORDER_PROPERTY, (long)this.getOrder());
        node.setProperty(LOCALNAME_PROPERTY, this.getLocalName());
        node.setProperty(VALUE_PROPERTY, this.getValue());
        this.node = node;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.getLocalName().hashCode();
        result = 31 * result + this.getNamespace().hashCode();
        result = 31 * result + this.getValue().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JCRProperty other = (JCRProperty)obj;
        if (this.getLocalName() != null ? !this.getLocalName().equals(other.getLocalName()) : other.getLocalName() != null) {
            return false;
        }
        if (this.getNamespace() != null ? !this.getNamespace().equals(other.getNamespace()) : other.getNamespace() != null) {
            return false;
        }
        return !(this.getValue() != null ? !this.getValue().equals(other.getValue()) : other.getValue() != null);
    }

    public String toString() {
        String result = "Property ( localName = " + this.getLocalName() + " " + "namespace = " + this.getNamespace() + " " + "value = " + this.getValue() + " )";
        return result;
    }
}

