/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr.user.model;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.james.mailbox.jcr.JCRImapConstants;
import org.apache.james.mailbox.jcr.Persistent;
import org.apache.james.mailbox.store.user.model.Subscription;
import org.slf4j.Logger;

public class JCRSubscription
implements Subscription,
Persistent,
JCRImapConstants {
    private static final String TOSTRING_SEPARATOR = " ";
    public static final String USERNAME_PROPERTY = "jamesMailbox:user";
    public static final String MAILBOXES_PROPERTY = "jamesMailbox:subscriptionMailboxes";
    private Node node;
    private final Logger log;
    private String mailbox;
    private String username;

    public JCRSubscription(Node node, String mailbox, Logger log) {
        this.node = node;
        this.log = log;
        this.mailbox = mailbox;
    }

    public JCRSubscription(String username, String mailbox, Logger log) {
        this.username = username;
        this.mailbox = mailbox;
        this.log = log;
    }

    public String getMailbox() {
        return this.mailbox;
    }

    public String getUser() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(USERNAME_PROPERTY).getString();
            }
            catch (RepositoryException e) {
                this.log.error("Unable to access Property jamesMailbox:user", (Throwable)e);
                return null;
            }
        }
        return this.username;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public boolean isPersistent() {
        return this.node != null;
    }

    @Override
    public void merge(Node node) throws RepositoryException {
        node.setProperty(USERNAME_PROPERTY, this.getUser());
        if (node.hasProperty(MAILBOXES_PROPERTY)) {
            Value[] mailboxes = node.getProperty(MAILBOXES_PROPERTY).getValues();
            ArrayList<String> newMailboxes = new ArrayList<String>();
            for (int i = 0; i < mailboxes.length; ++i) {
                String m = mailboxes[i].getString();
                newMailboxes.add(m);
            }
            if (!newMailboxes.contains(this.getMailbox())) {
                newMailboxes.add(this.getMailbox());
            }
            node.setProperty(MAILBOXES_PROPERTY, newMailboxes.toArray(new String[newMailboxes.size()]));
        } else {
            node.setProperty(MAILBOXES_PROPERTY, new String[]{this.getMailbox()});
        }
        this.node = node;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.getUser().hashCode();
        result = 31 * result + this.getMailbox().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JCRSubscription other = (JCRSubscription)obj;
        if (this.getUser() != null ? !this.getUser().equals(other.getUser()) : other.getUser() != null) {
            return false;
        }
        return !(this.getMailbox() != null ? !this.getMailbox().equals(other.getMailbox()) : other.getMailbox() != null);
    }

    public String toString() {
        String result = "Subscription ( user = " + this.getUser() + TOSTRING_SEPARATOR + "mailbox = " + this.getMailbox() + TOSTRING_SEPARATOR + " )";
        return result;
    }
}

