/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import java.io.Serializable;
import javax.naming.NamingException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.ldap.SimpleLDAPConnection;

public class ReadOnlyLDAPUser
implements User,
Serializable {
    private static final long serialVersionUID = -6712066073820393235L;
    private String userName;
    private String userDN;
    private String ldapURL;

    public ReadOnlyLDAPUser(String userName, String userDN, String ldapURL) {
        this.userName = userName;
        this.userDN = userDN;
        this.ldapURL = ldapURL;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean setPassword(String newPass) {
        return false;
    }

    public boolean verifyPassword(String password) {
        boolean result;
        try {
            SimpleLDAPConnection.openLDAPConnection(this.userDN, password, this.ldapURL);
            result = true;
        }
        catch (NamingException exception) {
            result = false;
        }
        return result;
    }
}

