/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.ldap.ReadOnlyLDAPGroupRestriction;
import org.apache.james.user.ldap.ReadOnlyLDAPUser;
import org.apache.james.user.ldap.SimpleLDAPConnection;
import org.slf4j.Logger;

public class ReadOnlyUsersLDAPRepository
implements UsersRepository,
Configurable,
LogEnabled {
    private String ldapHost;
    private String userIdAttribute;
    private String userObjectClass;
    private String userBase;
    private String principal;
    private String credentials;
    private ReadOnlyLDAPGroupRestriction restriction;
    private SimpleLDAPConnection ldapConnection;
    private Logger log;

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.ldapHost = configuration.getString("[@ldapHost]");
        this.principal = configuration.getString("[@principal]");
        this.credentials = configuration.getString("[@credentials]");
        this.userBase = configuration.getString("[@userBase]");
        this.userIdAttribute = configuration.getString("[@userIdAttribute]");
        this.userObjectClass = configuration.getString("[@userObjectClass]");
        SubnodeConfiguration restrictionConfig = null;
        if (configuration.containsKey("restriction[@memberAttribute]")) {
            restrictionConfig = configuration.configurationAt("restriction");
        }
        this.restriction = new ReadOnlyLDAPGroupRestriction((HierarchicalConfiguration)restrictionConfig);
    }

    @PostConstruct
    public void init() throws Exception {
        StringBuffer logBuffer;
        if (this.log.isDebugEnabled()) {
            logBuffer = new StringBuffer(128).append(this.getClass().getName()).append(".initialize()");
            this.log.debug(logBuffer.toString());
            logBuffer = new StringBuffer(256).append("Openning connection to LDAP host: ").append(this.ldapHost).append(".");
            this.log.debug(logBuffer.toString());
        }
        this.ldapConnection = SimpleLDAPConnection.openLDAPConnection(this.principal, this.credentials, this.ldapHost);
        if (this.log.isDebugEnabled()) {
            logBuffer = new StringBuffer(256).append("Initialization complete. User baseDN=").append(this.userBase).append(" ; userIdAttribute=" + this.userIdAttribute).append("\n\tGroup restriction:" + this.restriction);
            this.log.debug(logBuffer.toString());
        }
    }

    private boolean userInGroupsMembershipList(String userDN, Map<String, Collection<String>> groupMembershipList) {
        boolean result = false;
        Collection<Collection<String>> memberLists = groupMembershipList.values();
        Iterator<Collection<String>> memberListsIterator = memberLists.iterator();
        while (memberListsIterator.hasNext() && !result) {
            Collection<String> groupMembers = memberListsIterator.next();
            result = groupMembers.contains(userDN);
        }
        return result;
    }

    private Set<String> getAllUsersFromLDAP() throws NamingException {
        HashSet<String> result = new HashSet<String>();
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        sc.setReturningAttributes(new String[]{"distinguishedName"});
        NamingEnumeration<SearchResult> sr = this.ldapConnection.getLdapContext().search(this.userBase, "(objectClass=" + this.userObjectClass + ")", sc);
        while (sr.hasMore()) {
            SearchResult r = sr.next();
            result.add(r.getNameInNamespace());
        }
        return result;
    }

    private Collection<ReadOnlyLDAPUser> buildUserCollection(Collection<String> userDNs) throws NamingException {
        ArrayList<ReadOnlyLDAPUser> results = new ArrayList<ReadOnlyLDAPUser>();
        Iterator<String> userDNIterator = userDNs.iterator();
        while (userDNIterator.hasNext()) {
            ReadOnlyLDAPUser user = this.buildUser(userDNIterator.next());
            results.add(user);
        }
        return results;
    }

    private ReadOnlyLDAPUser buildUser(String userDN) throws NamingException {
        Attributes userAttributes = this.ldapConnection.getLdapContext().getAttributes(userDN);
        Attribute userName = userAttributes.get(this.userIdAttribute);
        ReadOnlyLDAPUser result = new ReadOnlyLDAPUser(userName.get().toString(), userDN, this.ldapHost);
        return result;
    }

    public boolean contains(String name) throws UsersRepositoryException {
        return this.getUserByName(name) != null;
    }

    public boolean containsCaseInsensitive(String name) throws UsersRepositoryException {
        return this.getUserByNameCaseInsensitive(name) != null;
    }

    public int countUsers() throws UsersRepositoryException {
        try {
            return this.getValidUsers().size();
        }
        catch (NamingException e) {
            this.log.error("Unable to retrieve user count from ldap", (Throwable)e);
            throw new UsersRepositoryException("Unable to retrieve user count from ldap", (Throwable)e);
        }
    }

    public String getRealName(String name) throws UsersRepositoryException {
        User u = this.getUserByNameCaseInsensitive(name);
        if (u != null) {
            return u.getUserName();
        }
        return null;
    }

    public User getUserByName(String name) throws UsersRepositoryException {
        try {
            for (ReadOnlyLDAPUser u : this.buildUserCollection(this.getValidUsers())) {
                if (!u.getUserName().equals(name)) continue;
                return u;
            }
        }
        catch (NamingException e) {
            this.log.error("Unable to retrieve user from ldap", (Throwable)e);
            throw new UsersRepositoryException("Unable to retrieve user from ldap", (Throwable)e);
        }
        return null;
    }

    public User getUserByNameCaseInsensitive(String name) throws UsersRepositoryException {
        try {
            for (ReadOnlyLDAPUser u : this.buildUserCollection(this.getValidUsers())) {
                if (!u.getUserName().equalsIgnoreCase(name)) continue;
                return u;
            }
        }
        catch (NamingException e) {
            this.log.error("Unable to retrieve user from ldap", (Throwable)e);
            throw new UsersRepositoryException("Unable to retrieve user from ldap", (Throwable)e);
        }
        return null;
    }

    public Iterator<String> list() throws UsersRepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Iterator<ReadOnlyLDAPUser> userIt = this.buildUserCollection(this.getValidUsers()).iterator();
            while (userIt.hasNext()) {
                result.add(userIt.next().getUserName());
            }
        }
        catch (NamingException namingException) {
            throw new UsersRepositoryException("Unable to retrieve users list from LDAP due to unknown naming error.", (Throwable)namingException);
        }
        return result.iterator();
    }

    private Collection<String> getValidUsers() throws NamingException {
        Collection<String> validUserDNs;
        Set<String> userDNs = this.getAllUsersFromLDAP();
        if (this.restriction.isActivated()) {
            Map<String, Collection<String>> groupMembershipList = this.restriction.getGroupMembershipLists(this.ldapConnection);
            validUserDNs = new ArrayList();
            for (String userDN : userDNs) {
                if (!this.userInGroupsMembershipList(userDN, groupMembershipList)) continue;
                validUserDNs.add(userDN);
            }
        } else {
            validUserDNs = userDNs;
        }
        return validUserDNs;
    }

    public void removeUser(String name) throws UsersRepositoryException {
        this.log.warn("This user-repository is read-only. Modifications are not permitted.");
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public boolean test(String name, String password) throws UsersRepositoryException {
        User u = this.getUserByName(name);
        if (u != null) {
            return u.verifyPassword(password);
        }
        return false;
    }

    public void addUser(String username, String password) throws UsersRepositoryException {
        this.log.warn("This user-repository is read-only. Modifications are not permitted.");
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public void updateUser(User user) throws UsersRepositoryException {
        this.log.warn("This user-repository is read-only. Modifications are not permitted.");
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public boolean supportVirtualHosting() throws UsersRepositoryException {
        return false;
    }
}

