/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class SimpleLDAPConnection {
    private String principal;
    private String credentials;
    private String ldapURL;
    private DirContext ldapContext;

    private SimpleLDAPConnection(String principal, String credentials, String ldapURL) {
        this.principal = principal;
        this.credentials = credentials;
        this.ldapURL = ldapURL;
    }

    public static SimpleLDAPConnection openLDAPConnection(String principal, String credentials, String ldapURL) throws NamingException {
        SimpleLDAPConnection result = new SimpleLDAPConnection(principal, credentials, ldapURL);
        result.initializeContext();
        return result;
    }

    public DirContext getLdapContext() {
        return this.ldapContext;
    }

    private void initializeContext() throws NamingException {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        props.put("java.naming.provider.url", this.ldapURL);
        props.put("java.naming.security.authentication", "simple");
        props.put("java.naming.security.principal", this.principal);
        props.put("java.naming.security.credentials", this.credentials);
        this.ldapContext = new InitialDirContext(props);
    }
}

