/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public abstract class AbstractAddFooter
extends GenericMailet {
    public void service(Mail mail) throws MessagingException {
        try {
            MimeMessage message = mail.getMessage();
            if (this.attachFooter((MimePart)message)) {
                message.saveChanges();
            } else {
                this.log("Unable to add footer to mail " + mail.getName());
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log("UnsupportedEncoding Unable to add footer to mail " + mail.getName());
        }
        catch (IOException ioe) {
            throw new MessagingException("Could not read message", (Exception)ioe);
        }
    }

    protected void addToText(MimePart part) throws MessagingException, IOException {
        String contentType = part.getContentType();
        String content = (String)part.getContent();
        if (!content.endsWith("\n")) {
            content = content + "\r\n";
        }
        content = content + this.getFooterText();
        part.setContent((Object)content, contentType);
        part.setHeader("Content-Type", contentType);
    }

    protected void addToHTML(MimePart part) throws MessagingException, IOException {
        String contentType = part.getContentType();
        String content = (String)part.getContent();
        int index = content.lastIndexOf("</body>");
        if (index == -1) {
            index = content.lastIndexOf("</BODY>");
        }
        String insert = "<br>" + this.getFooterHTML();
        content = index == -1 ? content + insert : content.substring(0, index) + insert + content.substring(index);
        part.setContent((Object)content, contentType);
        part.setHeader("Content-Type", contentType);
    }

    protected boolean attachFooter(MimePart part) throws MessagingException, IOException {
        if (part.isMimeType("text/plain") && part.getContent() instanceof String) {
            this.addToText(part);
            return true;
        }
        if (part.isMimeType("text/html") && part.getContent() instanceof String) {
            this.addToHTML(part);
            return true;
        }
        if (part.isMimeType("multipart/mixed") || part.isMimeType("multipart/related")) {
            MimeMultipart multipart = (MimeMultipart)part.getContent();
            MimeBodyPart firstPart = (MimeBodyPart)multipart.getBodyPart(0);
            boolean isFooterAttached = this.attachFooter((MimePart)firstPart);
            if (isFooterAttached) {
                part.setContent((Multipart)multipart);
            }
            return isFooterAttached;
        }
        if (part.isMimeType("multipart/alternative")) {
            MimeMultipart multipart = (MimeMultipart)part.getContent();
            int count = multipart.getCount();
            boolean isFooterAttached = false;
            for (int index = 0; index < count; ++index) {
                MimeBodyPart mimeBodyPart = (MimeBodyPart)multipart.getBodyPart(index);
                isFooterAttached |= this.attachFooter((MimePart)mimeBodyPart);
            }
            if (isFooterAttached) {
                part.setContent((Multipart)multipart);
            }
            return isFooterAttached;
        }
        return false;
    }

    protected abstract String getFooterText();

    protected abstract String getFooterHTML();
}

