/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class AddSubjectPrefix
extends GenericMailet {
    private String subjectPrefix = null;

    public void init() throws MessagingException {
        this.subjectPrefix = this.getInitParameter("subjectPrefix");
        if (this.subjectPrefix == null || this.subjectPrefix.equals("")) {
            throw new MessagingException("Please configure a valid subjectPrefix");
        }
    }

    public void service(Mail mail) throws MessagingException {
        String newSubject = null;
        MimeMessage m = mail.getMessage();
        String subject = m.getSubject();
        newSubject = subject != null ? this.subjectPrefix + " " + m.getSubject().toString() : this.subjectPrefix;
        String rawSubject = m.getHeader("Subject", null);
        String mimeCharset = AddSubjectPrefix.determineMailHeaderEncodingCharset(rawSubject);
        if (mimeCharset == null) {
            m.setSubject(newSubject);
            return;
        }
        String javaCharset = MimeUtility.javaCharset((String)mimeCharset);
        try {
            m.setSubject(newSubject, javaCharset);
        }
        catch (MessagingException e) {
            m.setSubject(newSubject);
        }
        m.saveChanges();
    }

    public String getMailetInfo() {
        return "AddSubjectPrefix Mailet";
    }

    private static String determineMailHeaderEncodingCharset(String rawText) {
        if (rawText == null) {
            return null;
        }
        int iEncodingPrefix = rawText.indexOf("=?");
        if (iEncodingPrefix == -1) {
            return null;
        }
        int iCharsetBegin = iEncodingPrefix + 2;
        int iSecondQuestionMark = rawText.indexOf(63, iCharsetBegin);
        if (iSecondQuestionMark == -1) {
            return null;
        }
        if (iSecondQuestionMark == iCharsetBegin) {
            return null;
        }
        int iThirdQuestionMark = rawText.indexOf(63, iSecondQuestionMark + 1);
        if (iThirdQuestionMark == -1) {
            return null;
        }
        if (-1 == rawText.indexOf("?=", iThirdQuestionMark + 1)) {
            return null;
        }
        String mimeCharset = rawText.substring(iCharsetBegin, iSecondQuestionMark);
        return mimeCharset;
    }
}

