/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadersToHTTP
extends GenericMailet {
    private String url;
    private String parameterKey = null;
    private String parameterValue = null;
    private boolean passThrough = true;

    public void init() throws MessagingException {
        this.passThrough = this.getInitParameter("passThrough", "true").compareToIgnoreCase("true") == 0;
        String targetUrl = this.getInitParameter("url");
        this.parameterKey = this.getInitParameter("parameterKey");
        this.parameterValue = this.getInitParameter("parameterValue");
        if (targetUrl == null || targetUrl.equals("")) {
            throw new MessagingException("Please configure a targetUrl (\"url\")");
        }
        try {
            this.url = new URL(targetUrl).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new MessagingException("Unable to contruct URL object from url");
        }
        this.log("I will attempt to deliver serialised messages to " + targetUrl + ". " + (this.parameterKey == null || this.parameterKey.length() < 1 ? "I will not add any fields to the post. " : "I will prepend: " + this.parameterKey + "=" + this.parameterValue + ". ") + (this.passThrough ? "Messages will pass through." : "Messages will be ghosted."));
    }

    public void service(Mail mail) {
        try {
            this.log(mail.getName() + "HeadersToHTTP: Starting");
            MimeMessage message = mail.getMessage();
            HashSet<NameValuePair> pairs = this.getNameValuePairs(message);
            this.log(mail.getName() + "HeadersToHTTP: " + pairs.size() + " named value pairs found");
            String result = this.httpPost(pairs);
            if (this.passThrough) {
                this.addHeader(mail, true, result);
            } else {
                mail.setState("ghost");
            }
        }
        catch (MessagingException me) {
            this.log(me.getMessage());
            this.addHeader(mail, false, me.getMessage());
        }
        catch (IOException e) {
            this.log(e.getMessage());
            this.addHeader(mail, false, e.getMessage());
        }
    }

    private void addHeader(Mail mail, boolean success, String errorMessage) {
        try {
            MimeMessage message = mail.getMessage();
            message.setHeader("X-headerToHTTP", success ? "Succeeded" : "Failed");
            if (!success && errorMessage != null && errorMessage.length() > 0) {
                message.setHeader("X-headerToHTTPFailure", errorMessage);
            }
            message.saveChanges();
        }
        catch (MessagingException e) {
            this.log(e.getMessage());
        }
    }

    private String httpPost(HashSet<NameValuePair> pairs) throws HttpException, IOException {
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(this.url);
        post.setRequestBody(this.setToArray(pairs));
        int statusCode = client.executeMethod((HttpMethod)post);
        String result = statusCode + ": " + post.getStatusLine().toString();
        this.log("HeadersToHTTP: " + result);
        return result;
    }

    private NameValuePair[] setToArray(HashSet<NameValuePair> pairs) {
        NameValuePair[] r = new NameValuePair[pairs.size()];
        int i = 0;
        Iterator<NameValuePair> i$ = pairs.iterator();
        while (i$.hasNext()) {
            NameValuePair p;
            r[i] = p = i$.next();
            ++i;
        }
        return r;
    }

    private HashSet<NameValuePair> getNameValuePairs(MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        HashSet<NameValuePair> pairs = new HashSet<NameValuePair>();
        if (message != null) {
            if (message.getSender() != null) {
                pairs.add(new NameValuePair("from", message.getSender().toString()));
            }
            if (message.getReplyTo() != null) {
                pairs.add(new NameValuePair("reply_to", message.getReplyTo().toString()));
            }
            if (message.getMessageID() != null) {
                pairs.add(new NameValuePair("message_id", message.getMessageID()));
            }
            if (message.getSubject() != null) {
                pairs.add(new NameValuePair("subject", message.getSubject()));
            }
            pairs.add(new NameValuePair("size", Integer.toString(message.getSize())));
        }
        pairs.add(new NameValuePair(this.parameterKey, this.parameterValue));
        return pairs;
    }

    public String getMailetInfo() {
        return "HTTP POST serialised message";
    }
}

