/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class LogMessage
extends GenericMailet {
    private boolean passThrough = true;
    private boolean headers = true;
    private boolean body = true;
    private int bodyMax = 0;
    private String comment = null;

    public void init() {
        try {
            this.passThrough = this.getInitParameter("passThrough") == null ? true : new Boolean(this.getInitParameter("passThrough"));
            this.headers = this.getInitParameter("headers") == null ? true : new Boolean(this.getInitParameter("headers"));
            this.body = this.getInitParameter("body") == null ? true : new Boolean(this.getInitParameter("body"));
            this.bodyMax = this.getInitParameter("maxBody") == null ? 0 : Integer.parseInt(this.getInitParameter("maxBody"));
            this.comment = this.getInitParameter("comment");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void service(Mail mail) {
        this.log(new StringBuffer(160).append("Logging mail ").append(mail.getName()).toString());
        if (this.comment != null) {
            this.log(this.comment);
        }
        try {
            if (this.headers) {
                this.log(this.getMessageHeaders(mail.getMessage()));
            }
            if (this.body) {
                int len = this.bodyMax > 0 ? this.bodyMax : mail.getMessage().getSize();
                StringBuffer text = new StringBuffer(len);
                InputStream is = mail.getMessage().getRawInputStream();
                byte[] buf = new byte[1024];
                int read = 0;
                while (text.length() < len && (read = is.read(buf)) > -1) {
                    text.append(new String(buf, 0, Math.min(read, len - text.length())));
                }
                this.log(text.toString());
            }
        }
        catch (MessagingException e) {
            this.log("Error logging message.", e);
        }
        catch (IOException e) {
            this.log("Error logging message.", e);
        }
        if (!this.passThrough) {
            mail.setState("ghost");
        }
    }

    private String getMessageHeaders(MimeMessage message) throws MessagingException {
        Enumeration heads = message.getAllHeaderLines();
        StringBuffer headBuffer = new StringBuffer(1024).append("\n");
        while (heads.hasMoreElements()) {
            headBuffer.append(heads.nextElement().toString()).append("\n");
        }
        return headBuffer.toString();
    }

    public String getMailetInfo() {
        return "LogHeaders Mailet";
    }
}

