/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.HashMap;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class MailAttributesToMimeHeaders
extends GenericMailet {
    private HashMap<String, String> map = new HashMap();

    public void init() throws MessagingException {
        String simplemappings = this.getInitParameter("simplemapping");
        if (simplemappings != null) {
            StringTokenizer st = new StringTokenizer(simplemappings, ",");
            while (st.hasMoreTokens()) {
                String[] parameters = st.nextToken().split(";");
                if (parameters.length > 2 || parameters.length < 2) {
                    throw new MessagingException("Invalid config. Please use \"attributeName; headerName\"");
                }
                this.map.put(parameters[0].trim(), parameters[1].trim());
            }
        } else {
            throw new MessagingException("Invalid config. Please use \"attributeName; headerName\"");
        }
    }

    public void service(Mail mail) {
        try {
            MimeMessage message = mail.getMessage();
            for (String key : this.map.keySet()) {
                String value = (String)((Object)mail.getAttribute(key));
                String headerName = this.map.get(key);
                if (headerName == null || value == null) continue;
                message.setHeader(headerName, value);
            }
            message.saveChanges();
        }
        catch (MessagingException e) {
            this.log(e.getMessage());
        }
    }
}

