/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;

public class RemoveMailAttribute
extends GenericMailet {
    private ArrayList<String> attributesToRemove = new ArrayList();

    public String getMailetInfo() {
        return "Remove Mail Attribute Mailet";
    }

    public void init() throws MailetException {
        String name = this.getInitParameter("name");
        if (name != null) {
            StringTokenizer st = new StringTokenizer(name, ",");
            while (st.hasMoreTokens()) {
                String attribute_name = st.nextToken().trim();
                this.attributesToRemove.add(attribute_name);
            }
        } else {
            throw new MailetException("Please configure at least one attribute to remove");
        }
    }

    public void service(Mail mail) throws MessagingException {
        Iterator<String> iter = this.attributesToRemove.iterator();
        while (iter.hasNext()) {
            String attribute_name = iter.next().toString();
            mail.removeAttribute(attribute_name);
        }
    }
}

