/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;

public class RemoveMimeHeader
extends GenericMailet {
    ArrayList<String> headers = new ArrayList();

    public void init() throws MailetException {
        String header = this.getInitParameter("name");
        if (header != null) {
            StringTokenizer st = new StringTokenizer(header, ",");
            while (st.hasMoreTokens()) {
                this.headers.add(st.nextToken());
            }
        } else {
            throw new MailetException("Invalid config. Please specify atleast one name");
        }
    }

    public void service(Mail mail) {
        try {
            MimeMessage message = mail.getMessage();
            for (int i = 0; i < this.headers.size(); ++i) {
                message.removeHeader(this.headers.get(i));
            }
            message.saveChanges();
        }
        catch (MessagingException e) {
            this.log("Unable to remove headers: " + e.getMessage());
        }
    }

    public String getMailetInfo() {
        return "RemoveMimeHeader Mailet";
    }
}

