/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import org.apache.james.transport.mailets.PatternBean;
import org.apache.james.transport.mailets.PatternList;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;
import org.apache.mailet.base.StringUtils;

public class ReplaceContent
extends GenericMailet {
    private static final String PARAMETER_NAME_SUBJECT_PATTERN = "subjectPattern";
    private static final String PARAMETER_NAME_BODY_PATTERN = "bodyPattern";
    private static final String PARAMETER_NAME_SUBJECT_PATTERNFILE = "subjectPatternFile";
    private static final String PARAMETER_NAME_BODY_PATTERNFILE = "bodyPatternFile";
    private static final String PARAMETER_NAME_CHARSET = "charset";
    public static final int FLAG_REPEAT = 1;
    private String charset;
    private int debug = 0;

    public String getMailetInfo() {
        return "ReplaceContent";
    }

    protected static PatternBean getPattern(String line) throws MailetException {
        String[] pieces = StringUtils.split((String)line, (String)"/");
        if (pieces.length < 3) {
            throw new MailetException("Invalid expression: " + line);
        }
        int options = 0;
        if (pieces[2].indexOf(105) >= 0) {
            options += 2;
        }
        if (pieces[2].indexOf(109) >= 0) {
            options += 8;
        }
        if (pieces[2].indexOf(115) >= 0) {
            options += 32;
        }
        int flags = 0;
        if (pieces[2].indexOf(114) >= 0) {
            ++flags;
        }
        if (pieces[1].indexOf("\\r") >= 0) {
            pieces[1] = pieces[1].replaceAll("\\\\r", "\r");
        }
        if (pieces[1].indexOf("\\n") >= 0) {
            pieces[1] = pieces[1].replaceAll("\\\\n", "\n");
        }
        if (pieces[1].indexOf("\\t") >= 0) {
            pieces[1] = pieces[1].replaceAll("\\\\t", "\t");
        }
        return new PatternBean(Pattern.compile(pieces[0], options), pieces[1], new Integer(flags));
    }

    protected static PatternList getPatternsFromString(String pattern) throws MailetException {
        if ((pattern = pattern.trim()).length() < 2 && !pattern.startsWith("/") && !pattern.endsWith("/")) {
            throw new MailetException("Invalid parameter value: subjectPattern");
        }
        pattern = pattern.substring(1, pattern.length() - 1);
        String[] patternArray = StringUtils.split((String)pattern, (String)"/,/");
        PatternList patternList = new PatternList();
        for (int i = 0; i < patternArray.length; ++i) {
            PatternBean o = ReplaceContent.getPattern(patternArray[i]);
            patternList.getPatterns().add(o.getPatterns());
            patternList.getSubstitutions().add(o.getSubstitutions());
            patternList.getFlags().add(o.getFlag());
        }
        return patternList;
    }

    protected static PatternList getPatternsFromStream(InputStream stream, String charset) throws MailetException, IOException {
        String line;
        PatternList patternList = new PatternList();
        BufferedReader reader = new BufferedReader(charset != null ? new InputStreamReader(stream, charset) : new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
            if (line.length() < 2 && !line.startsWith("/") && !line.endsWith("/")) {
                throw new MailetException("Invalid expression: " + line);
            }
            PatternBean o = ReplaceContent.getPattern(line.substring(1, line.length() - 1));
            patternList.getPatterns().add(o.getPatterns());
            patternList.getSubstitutions().add(o.getSubstitutions());
            patternList.getFlags().add(o.getFlag());
        }
        reader.close();
        return patternList;
    }

    private PatternList getPatternsFromFileList(String filepar) throws MailetException, IOException {
        PatternList patternList = new PatternList();
        String[] files = filepar.split(",");
        for (int i = 0; i < files.length; ++i) {
            files[i] = files[i].trim();
            if (this.debug > 0) {
                this.log("Loading patterns from: " + files[i]);
            }
            String charset = null;
            int pc = files[i].lastIndexOf(63);
            if (pc >= 0) {
                charset = files[i].substring(pc + 1);
                files[i] = files[i].substring(0, pc);
            }
            InputStream is = null;
            if (files[i].startsWith("#")) {
                is = ((Object)((Object)this)).getClass().getResourceAsStream(files[i].substring(1));
            } else {
                File f = new File(files[i]);
                if (f.isFile()) {
                    is = new FileInputStream(f);
                }
            }
            if (is == null) continue;
            PatternList o = ReplaceContent.getPatternsFromStream(is, charset);
            patternList.getPatterns().addAll(o.getPatterns());
            patternList.getSubstitutions().addAll(o.getSubstitutions());
            patternList.getFlags().addAll(o.getFlags());
            is.close();
        }
        return patternList;
    }

    protected static String applyPatterns(Pattern[] patterns, String[] substitutions, Integer[] pflags, String text, int debug, GenericMailet logOwner) {
        for (int i = 0; i < patterns.length; ++i) {
            int flags = pflags[i];
            boolean changed = false;
            do {
                changed = false;
                String replaced = patterns[i].matcher(text).replaceAll(substitutions[i]);
                if (replaced.equals(text)) continue;
                if (debug > 0) {
                    logOwner.log("Subject rule match: " + patterns[i].pattern());
                }
                text = replaced;
                changed = true;
            } while ((flags & 1) > 0 && changed);
        }
        return text;
    }

    public void init() throws MailetException {
        this.charset = this.getInitParameter(PARAMETER_NAME_CHARSET);
        this.debug = Integer.parseInt(this.getInitParameter("debug", "0"));
    }

    private ReplaceConfig initPatterns() throws MailetException {
        try {
            PatternList o;
            String filepar;
            PatternList o2;
            ArrayList<Pattern> bodyPatternsList = new ArrayList<Pattern>();
            ArrayList<String> bodySubstitutionsList = new ArrayList<String>();
            ArrayList<Integer> bodyFlagsList = new ArrayList<Integer>();
            ArrayList<Pattern> subjectPatternsList = new ArrayList<Pattern>();
            ArrayList<String> subjectSubstitutionsList = new ArrayList<String>();
            ArrayList<Integer> subjectFlagsList = new ArrayList<Integer>();
            String pattern = this.getInitParameter(PARAMETER_NAME_SUBJECT_PATTERN);
            if (pattern != null) {
                o2 = ReplaceContent.getPatternsFromString(pattern);
                subjectPatternsList.addAll(o2.getPatterns());
                subjectSubstitutionsList.addAll(o2.getSubstitutions());
                subjectFlagsList.addAll(o2.getFlags());
            }
            if ((pattern = this.getInitParameter(PARAMETER_NAME_BODY_PATTERN)) != null) {
                o2 = ReplaceContent.getPatternsFromString(pattern);
                bodyPatternsList.addAll(o2.getPatterns());
                bodySubstitutionsList.addAll(o2.getSubstitutions());
                bodyFlagsList.addAll(o2.getFlags());
            }
            if ((filepar = this.getInitParameter(PARAMETER_NAME_SUBJECT_PATTERNFILE)) != null) {
                o = this.getPatternsFromFileList(filepar);
                subjectPatternsList.addAll(o.getPatterns());
                subjectSubstitutionsList.addAll(o.getSubstitutions());
                subjectFlagsList.addAll(o.getFlags());
            }
            if ((filepar = this.getInitParameter(PARAMETER_NAME_BODY_PATTERNFILE)) != null) {
                o = this.getPatternsFromFileList(filepar);
                bodyPatternsList.addAll(o.getPatterns());
                bodySubstitutionsList.addAll(o.getSubstitutions());
                bodyFlagsList.addAll(o.getFlags());
            }
            ReplaceConfig rConfig = new ReplaceConfig();
            ReplaceConfig.access$102(rConfig, subjectPatternsList.toArray(new Pattern[0]));
            ReplaceConfig.access$202(rConfig, subjectSubstitutionsList.toArray(new String[0]));
            ReplaceConfig.access$302(rConfig, subjectFlagsList.toArray(new Integer[0]));
            ReplaceConfig.access$402(rConfig, bodyPatternsList.toArray(new Pattern[0]));
            ReplaceConfig.access$502(rConfig, bodySubstitutionsList.toArray(new String[0]));
            ReplaceConfig.access$602(rConfig, bodyFlagsList.toArray(new Integer[0]));
            return rConfig;
        }
        catch (FileNotFoundException e) {
            throw new MailetException("Failed initialization", (Exception)e);
        }
        catch (MailetException e) {
            throw new MailetException("Failed initialization", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MailetException("Failed initialization", (Exception)e);
        }
    }

    public void service(Mail mail) throws MailetException {
        ReplaceConfig rConfig = this.initPatterns();
        try {
            boolean mod = false;
            boolean contentChanged = false;
            if (rConfig.subjectPatterns != null && rConfig.subjectPatterns.length > 0) {
                String subject = mail.getMessage().getSubject();
                if (subject == null) {
                    subject = "";
                }
                subject = ReplaceContent.applyPatterns(rConfig.subjectPatterns, rConfig.subjectSubstitutions, rConfig.subjectFlags, subject, this.debug, this);
                if (this.charset != null) {
                    mail.getMessage().setSubject(subject, this.charset);
                } else {
                    mail.getMessage().setSubject(subject);
                }
                mod = true;
            }
            if (rConfig.bodyPatterns != null && rConfig.bodyPatterns.length > 0) {
                Object bodyObj = mail.getMessage().getContent();
                if (bodyObj == null) {
                    bodyObj = "";
                }
                if (bodyObj instanceof String) {
                    String body = (String)bodyObj;
                    body = ReplaceContent.applyPatterns(rConfig.bodyPatterns, rConfig.bodySubstitutions, rConfig.bodyFlags, body, this.debug, this);
                    String contentType = mail.getMessage().getContentType();
                    if (this.charset != null) {
                        ContentType ct = new ContentType(contentType);
                        ct.setParameter(PARAMETER_NAME_CHARSET, this.charset);
                        contentType = ct.toString();
                    }
                    mail.getMessage().setContent((Object)body, contentType);
                    mod = true;
                    contentChanged = true;
                }
            }
            if (this.charset != null && !contentChanged) {
                ContentType ct = new ContentType(mail.getMessage().getContentType());
                ct.setParameter(PARAMETER_NAME_CHARSET, this.charset);
                String contentType = mail.getMessage().getContentType();
                mail.getMessage().setContent(mail.getMessage().getContent(), contentType);
            }
            if (mod) {
                mail.getMessage().saveChanges();
            }
        }
        catch (MessagingException e) {
            throw new MailetException("Error in replace", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MailetException("Error in replace", (Exception)e);
        }
    }

    private static class ReplaceConfig {
        private Pattern[] subjectPatterns;
        private String[] subjectSubstitutions;
        private Integer[] subjectFlags;
        private Pattern[] bodyPatterns;
        private String[] bodySubstitutions;
        private Integer[] bodyFlags;

        private ReplaceConfig() {
        }

        static /* synthetic */ Pattern[] access$102(ReplaceConfig x0, Pattern[] x1) {
            x0.subjectPatterns = x1;
            return x1;
        }

        static /* synthetic */ String[] access$202(ReplaceConfig x0, String[] x1) {
            x0.subjectSubstitutions = x1;
            return x1;
        }

        static /* synthetic */ Integer[] access$302(ReplaceConfig x0, Integer[] x1) {
            x0.subjectFlags = x1;
            return x1;
        }

        static /* synthetic */ Pattern[] access$402(ReplaceConfig x0, Pattern[] x1) {
            x0.bodyPatterns = x1;
            return x1;
        }

        static /* synthetic */ String[] access$502(ReplaceConfig x0, String[] x1) {
            x0.bodySubstitutions = x1;
            return x1;
        }

        static /* synthetic */ Integer[] access$602(ReplaceConfig x0, Integer[] x1) {
            x0.bodyFlags = x1;
            return x1;
        }
    }
}

