/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class SerialiseToHTTP
extends GenericMailet {
    private String url;
    private String parameterKey = null;
    private String parameterValue = null;
    private String messageKeyName = "message";
    private boolean passThrough = true;

    public void init() throws MessagingException {
        this.passThrough = this.getInitParameter("passThrough", "true").compareToIgnoreCase("true") == 0;
        String targetUrl = this.getInitParameter("url");
        this.parameterKey = this.getInitParameter("parameterKey");
        this.parameterValue = this.getInitParameter("parameterValue");
        String m = this.getInitParameter("MessageKeyName");
        if (m != null) {
            this.messageKeyName = m;
        }
        if (targetUrl == null || targetUrl.equals("")) {
            throw new MessagingException("Please configure a targetUrl (\"url\")");
        }
        try {
            this.url = new URL(targetUrl).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new MessagingException("Unable to contruct URL object from url");
        }
        this.log("I will attempt to deliver serialised messages to " + targetUrl + " as " + this.messageKeyName + ". " + (this.parameterKey == null || this.parameterKey.length() < 2 ? "I will not add any fields to the post. " : "I will prepend: " + this.parameterKey + "=" + this.parameterValue + ". ") + (this.passThrough ? "Messages will pass through." : "Messages will be ghosted."));
    }

    public void service(Mail mail) {
        try {
            MimeMessage message = mail.getMessage();
            String serialisedMessage = this.getSerialisedMessage(message);
            NameValuePair[] nameValuePairs = this.getNameValuePairs(serialisedMessage);
            String result = this.httpPost(nameValuePairs);
            if (this.passThrough) {
                this.addHeader(mail, result == null || result.length() == 0, result);
            } else {
                mail.setState("ghost");
            }
        }
        catch (MessagingException me) {
            this.log(me.getMessage());
            this.addHeader(mail, false, me.getMessage());
        }
        catch (IOException e) {
            this.log(e.getMessage());
            this.addHeader(mail, false, e.getMessage());
        }
    }

    private void addHeader(Mail mail, boolean success, String errorMessage) {
        try {
            MimeMessage message = mail.getMessage();
            message.setHeader("X-toHTTP", success ? "Succeeded" : "Failed");
            if (!success && errorMessage != null && errorMessage.length() > 0) {
                message.setHeader("X-toHTTPFailure", errorMessage);
            }
            message.saveChanges();
        }
        catch (MessagingException e) {
            this.log(e.getMessage());
        }
    }

    private String getSerialisedMessage(MimeMessage message) throws IOException, MessagingException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        message.writeTo((OutputStream)os);
        return os.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpPost(NameValuePair[] data) {
        String response = null;
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(this.url);
        if (data.length > 1 && data[1] != null) {
            this.log(data[1].getName() + "::" + data[1].getValue());
        }
        post.setRequestBody(data);
        try {
            int statusCode = client.executeMethod((HttpMethod)post);
            if (statusCode != 200) {
                this.log("POST failed: " + post.getStatusLine());
                response = post.getStatusLine().toString();
            }
        }
        catch (HttpException e) {
            this.log("Fatal protocol violation: " + e.getMessage());
            response = "Fatal protocol violation: " + e.getMessage();
        }
        catch (IOException e) {
            this.log("Fatal transport error: " + e.getMessage());
            response = "Fatal transport error: " + e.getMessage();
        }
        finally {
            post.releaseConnection();
        }
        return response;
    }

    private NameValuePair[] getNameValuePairs(String message) throws UnsupportedEncodingException {
        int l = 1;
        if (this.parameterKey != null && this.parameterKey.length() > 0) {
            l = 2;
        }
        NameValuePair[] data = new NameValuePair[l];
        data[0] = new NameValuePair(this.messageKeyName, message);
        if (l == 2) {
            data[1] = new NameValuePair(this.parameterKey, this.parameterValue);
        }
        return data;
    }

    public String getMailetInfo() {
        return "HTTP POST serialised message";
    }
}

