/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.james.transport.mailets.PatternList;
import org.apache.james.transport.mailets.ReplaceContent;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;

public class StripAttachment
extends GenericMailet {
    public static final String PATTERN_PARAMETER_NAME = "pattern";
    public static final String NOTPATTERN_PARAMETER_NAME = "notpattern";
    public static final String ATTRIBUTE_PARAMETER_NAME = "attribute";
    public static final String DIRECTORY_PARAMETER_NAME = "directory";
    public static final String REMOVE_ATTACHMENT_PARAMETER_NAME = "remove";
    public static final String DECODE_FILENAME_PARAMETER_NAME = "decodeFilename";
    public static final String REPLACE_FILENAME_PATTERN_PARAMETER_NAME = "replaceFilenamePattern";
    public static final String REMOVE_NONE = "no";
    public static final String REMOVE_ALL = "all";
    public static final String REMOVE_MATCHED = "matched";
    public static final String REMOVED_ATTACHMENTS_ATTRIBUTE_KEY = "org.apache.james.transport.mailets.StripAttachment.removed";
    public static final String SAVED_ATTACHMENTS_ATTRIBUTE_KEY = "org.apache.james.transport.mailets.StripAttachment.saved";
    private String patternString = null;
    private String notpatternString = null;
    private String removeAttachments = null;
    private String directoryName = null;
    private String attributeName = null;
    private Pattern regExPattern = null;
    private Pattern notregExPattern = null;
    private boolean decodeFilename = false;
    private Pattern[] replaceFilenamePatterns = null;
    private String[] replaceFilenameSubstitutions = null;
    private Integer[] replaceFilenameFlags = null;

    private static boolean getBooleanParameter(String v, boolean def) {
        return def ? v == null || !v.equalsIgnoreCase("false") && !v.equalsIgnoreCase(REMOVE_NONE) : v != null && (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("yes"));
    }

    public void init() throws MailetException {
        this.patternString = this.getInitParameter(PATTERN_PARAMETER_NAME);
        this.notpatternString = this.getInitParameter(NOTPATTERN_PARAMETER_NAME);
        if (this.patternString == null && this.notpatternString == null) {
            throw new MailetException("No value for pattern parameter was provided.");
        }
        this.directoryName = this.getInitParameter(DIRECTORY_PARAMETER_NAME);
        this.attributeName = this.getInitParameter(ATTRIBUTE_PARAMETER_NAME);
        this.removeAttachments = this.getInitParameter(REMOVE_ATTACHMENT_PARAMETER_NAME, REMOVE_NONE).toLowerCase();
        if (!REMOVE_MATCHED.equals(this.removeAttachments) && !REMOVE_ALL.equals(this.removeAttachments)) {
            this.removeAttachments = REMOVE_NONE;
        }
        try {
            if (this.patternString != null) {
                this.regExPattern = Pattern.compile(this.patternString);
            }
        }
        catch (Exception e) {
            throw new MailetException("Could not compile regex [" + this.patternString + "].");
        }
        try {
            if (this.notpatternString != null) {
                this.notregExPattern = Pattern.compile(this.notpatternString);
            }
        }
        catch (Exception e) {
            throw new MailetException("Could not compile regex [" + this.notpatternString + "].");
        }
        if (this.directoryName != null) {
            try {
                File saveDirectory = null;
                saveDirectory = new File(this.directoryName);
                if (!saveDirectory.exists()) {
                    saveDirectory.mkdirs();
                }
            }
            catch (Exception e) {
                throw new MailetException("Could not create directory [" + this.directoryName + "].", e);
            }
        }
        this.decodeFilename = StripAttachment.getBooleanParameter(this.getInitParameter(DECODE_FILENAME_PARAMETER_NAME), this.decodeFilename);
        if (this.getInitParameter(REPLACE_FILENAME_PATTERN_PARAMETER_NAME) != null) {
            PatternList pl = ReplaceContent.getPatternsFromString(this.getInitParameter(REPLACE_FILENAME_PATTERN_PARAMETER_NAME));
            this.replaceFilenamePatterns = pl.getPatterns().toArray(new Pattern[0]);
            this.replaceFilenameSubstitutions = pl.getSubstitutions().toArray(new String[0]);
            this.replaceFilenameFlags = pl.getFlags().toArray(new Integer[0]);
        }
        String toLog = "StripAttachment is initialised with regex pattern [" + this.patternString + " / " + this.notpatternString + "]";
        if (this.directoryName != null) {
            toLog = toLog + " and will save to directory [" + this.directoryName + "]";
        }
        if (this.attributeName != null) {
            toLog = toLog + " and will store attachments to attribute [" + this.attributeName + "]";
        }
        this.log(toLog);
    }

    public void service(Mail mail) throws MailetException {
        MimeMessage message = null;
        try {
            message = mail.getMessage();
        }
        catch (MessagingException e) {
            throw new MailetException("Could not retrieve message from Mail object", (Exception)((Object)e));
        }
        try {
            if (message.isMimeType("multipart/*")) {
                this.analyseMultipartPartMessage((Part)message, mail);
            }
        }
        catch (MessagingException e) {
            throw new MailetException("Could not retrieve contenttype of message.", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MailetException("Could not analyse message.", e);
        }
    }

    public String getMailetInfo() {
        return "StripAttachment";
    }

    private boolean analyseMultipartPartMessage(Part part, Mail mail) throws Exception {
        if (part.isMimeType("multipart/*")) {
            try {
                Multipart multipart = (Multipart)part.getContent();
                boolean atLeastOneRemoved = false;
                int numParts = multipart.getCount();
                for (int i = 0; i < numParts; ++i) {
                    BodyPart p = multipart.getBodyPart(i);
                    if (p.isMimeType("multipart/*")) {
                        atLeastOneRemoved |= this.analyseMultipartPartMessage((Part)p, mail);
                        continue;
                    }
                    boolean removed = this.checkMessageRemoved((Part)p, mail);
                    if (!removed) continue;
                    multipart.removeBodyPart(i);
                    atLeastOneRemoved = true;
                    --i;
                    --numParts;
                }
                if (atLeastOneRemoved) {
                    part.setContent(multipart);
                    if (part instanceof Message) {
                        ((Message)part).saveChanges();
                    }
                }
                return atLeastOneRemoved;
            }
            catch (Exception e) {
                this.log("Could not analyse part.", e);
            }
        }
        return false;
    }

    private boolean checkMessageRemoved(Part part, Mail mail) throws MessagingException, Exception {
        String fileName = null;
        fileName = part.getFileName();
        boolean ret = false;
        if (fileName != null) {
            if (this.decodeFilename) {
                fileName = MimeUtility.decodeText((String)fileName);
            }
            if (this.replaceFilenamePatterns != null) {
                fileName = ReplaceContent.applyPatterns(this.replaceFilenamePatterns, this.replaceFilenameSubstitutions, this.replaceFilenameFlags, fileName, 0, this);
            }
            if (this.fileNameMatches(fileName)) {
                String filename;
                if (this.directoryName != null && (filename = this.saveAttachmentToFile(part, fileName)) != null) {
                    ArrayList<String> c = (ArrayList<String>)mail.getAttribute(SAVED_ATTACHMENTS_ATTRIBUTE_KEY);
                    if (c == null) {
                        c = new ArrayList<String>();
                        mail.setAttribute(SAVED_ATTACHMENTS_ATTRIBUTE_KEY, c);
                    }
                    c.add(filename);
                }
                if (this.attributeName != null) {
                    LinkedHashMap<String, byte[]> m = (LinkedHashMap<String, byte[]>)mail.getAttribute(this.attributeName);
                    if (m == null) {
                        m = new LinkedHashMap<String, byte[]>();
                        mail.setAttribute(this.attributeName, m);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    BufferedOutputStream os = new BufferedOutputStream(byteArrayOutputStream);
                    part.writeTo((OutputStream)os);
                    m.put(fileName, byteArrayOutputStream.toByteArray());
                }
                if (this.removeAttachments.equals(REMOVE_MATCHED)) {
                    ret = true;
                }
            }
            if (!ret) {
                ret = this.removeAttachments.equals(REMOVE_ALL);
            }
            if (ret) {
                ArrayList<String> c = (ArrayList<String>)mail.getAttribute(REMOVED_ATTACHMENTS_ATTRIBUTE_KEY);
                if (c == null) {
                    c = new ArrayList<String>();
                    mail.setAttribute(REMOVED_ATTACHMENTS_ATTRIBUTE_KEY, c);
                }
                c.add(fileName);
            }
        }
        return ret;
    }

    private boolean fileNameMatches(String name) {
        boolean result = true;
        if (this.regExPattern != null) {
            result = this.regExPattern.matcher(name).matches();
        }
        if (result && this.notregExPattern != null) {
            result = !this.notregExPattern.matcher(name).matches();
        }
        String log = "attachment " + name + " ";
        log = !result ? log + "does not match" : log + "matches";
        this.log(log);
        return result;
    }

    private String saveAttachmentToFile(Part part, String fileName) throws Exception {
        FilterOutputStream os = null;
        InputStream is = null;
        File f = null;
        try {
            int c;
            String suffix;
            if (fileName == null) {
                fileName = part.getFileName();
            }
            int pos = -1;
            if (fileName != null) {
                pos = fileName.lastIndexOf(".");
            }
            String prefix = pos > 0 ? fileName.substring(0, pos) : fileName;
            String string = suffix = pos > 0 ? fileName.substring(pos) : ".bin";
            while (prefix.length() < 3) {
                prefix = prefix + "_";
            }
            if (suffix.length() == 0) {
                suffix = ".bin";
            }
            f = File.createTempFile(prefix, suffix, new File(this.directoryName));
            this.log("saving content of " + f.getName() + "...");
            os = new BufferedOutputStream(new FileOutputStream(f));
            is = part.getInputStream();
            if (!(is instanceof BufferedInputStream)) {
                is = new BufferedInputStream(is);
            }
            while ((c = is.read()) != -1) {
                ((BufferedOutputStream)os).write(c);
            }
            String string2 = f.getName();
            return string2;
        }
        catch (Exception e) {
            this.log("Error while saving contents of [" + (f != null ? f.getName() : (part != null ? part.getFileName() : "NULL")) + "].", e);
            throw e;
        }
        finally {
            is.close();
            os.close();
        }
    }
}

