/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;

public class ToProcessor
extends GenericMailet {
    private boolean isDebug = false;
    String processor;
    String noticeText = null;

    public void init() throws MailetException {
        this.isDebug = this.getInitParameter("debug") == null ? false : new Boolean(this.getInitParameter("debug"));
        this.processor = this.getInitParameter("processor");
        if (this.processor == null) {
            throw new MailetException("processor parameter is required");
        }
        this.noticeText = this.getInitParameter("notice");
    }

    public void service(Mail mail) throws MessagingException {
        if (this.isDebug) {
            StringBuffer logBuffer = new StringBuffer(128).append("Sending mail ").append(mail).append(" to ").append(this.processor);
            this.log(logBuffer.toString());
        }
        mail.setState(this.processor);
        if (this.noticeText != null) {
            if (mail.getErrorMessage() == null) {
                mail.setErrorMessage(this.noticeText);
            } else {
                StringBuffer errorMessageBuffer = new StringBuffer(256).append(mail.getErrorMessage()).append("\r\n").append(this.noticeText);
                mail.setErrorMessage(errorMessageBuffer.toString());
            }
        }
    }

    public String getMailetInfo() {
        return "ToProcessor Mailet";
    }
}

