/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseHeaderRecipients
extends GenericMailet {
    private boolean isDebug = false;

    public void init() {
        this.isDebug = this.getInitParameter("debug") == null ? false : new Boolean(this.getInitParameter("debug"));
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        Collection recipients = mail.getRecipients();
        recipients.clear();
        recipients.addAll(this.getHeaderMailAddresses(message, "Mail-For"));
        if (recipients.isEmpty()) {
            recipients.addAll(this.getHeaderMailAddresses(message, "To"));
            recipients.addAll(this.getHeaderMailAddresses(message, "Cc"));
        }
        if (this.isDebug) {
            this.log("All recipients = " + recipients.toString());
            this.log("Reprocessing mail using recipients in message headers");
        }
        this.getMailetContext().sendMail(mail.getSender(), mail.getRecipients(), mail.getMessage());
        mail.setState("ghost");
    }

    public String getMailetInfo() {
        return "UseHeaderRecipients Mailet";
    }

    private Collection<MailAddress> getHeaderMailAddresses(MimeMessage message, String name) throws MessagingException {
        if (this.isDebug) {
            StringBuffer logBuffer = new StringBuffer(64).append("Checking ").append(name).append(" headers");
            this.log(logBuffer.toString());
        }
        Vector<MailAddress> addresses = new Vector<MailAddress>();
        String[] headers = message.getHeader(name);
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                StringTokenizer st = new StringTokenizer(headers[i], ",", false);
                while (st.hasMoreTokens()) {
                    String addressString = st.nextToken();
                    InternetAddress iAddress = new InternetAddress(addressString);
                    if (this.isDebug) {
                        this.log("Address = " + iAddress.toString());
                    }
                    addresses.add(new MailAddress(iAddress));
                }
            }
        }
        return addresses;
    }
}

