/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentFileNameIs
extends GenericMatcher {
    protected static final String UNZIP_REQUEST_PARAMETER = "-z";
    protected static final String DEBUG_REQUEST_PARAMETER = "-d";
    protected static final String ZIP_SUFFIX = ".zip";
    protected boolean isDebug = false;
    private Mask[] masks = null;
    protected boolean unzipIsRequested;

    public void init() throws MessagingException {
        StringTokenizer st = new StringTokenizer(this.getCondition(), ", ", false);
        ArrayList<Mask> theMasks = new ArrayList<Mask>(20);
        while (st.hasMoreTokens()) {
            String fileName = st.nextToken();
            if (theMasks.size() == 0 && fileName.equalsIgnoreCase(UNZIP_REQUEST_PARAMETER)) {
                this.unzipIsRequested = true;
                this.log("zip file analysis requested");
                continue;
            }
            if (theMasks.size() == 0 && fileName.equalsIgnoreCase(DEBUG_REQUEST_PARAMETER)) {
                this.isDebug = true;
                this.log("debug requested");
                continue;
            }
            Mask mask = new Mask();
            if (fileName.startsWith("*")) {
                mask.suffixMatch = true;
                mask.matchString = fileName.substring(1);
            } else {
                mask.suffixMatch = false;
                mask.matchString = fileName;
            }
            mask.matchString = this.cleanFileName(mask.matchString);
            theMasks.add(mask);
        }
        this.masks = theMasks.toArray(new Mask[0]);
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        try {
            MimeMessage message = mail.getMessage();
            if (this.matchFound((Part)message)) {
                return mail.getRecipients();
            }
            return null;
        }
        catch (Exception e) {
            if (this.isDebug) {
                this.log("Malformed message", e);
            }
            throw new MessagingException("Malformed message", e);
        }
    }

    protected boolean matchFound(Part part) throws Exception {
        Object content;
        if (part.getContentType() == null || part.getContentType().startsWith("multipart/alternative")) {
            return false;
        }
        try {
            content = part.getContent();
        }
        catch (UnsupportedEncodingException uee) {
            return false;
        }
        MessagingException anException = null;
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            for (int i = 0; i < multipart.getCount(); ++i) {
                try {
                    BodyPart bodyPart = multipart.getBodyPart(i);
                    if (!this.matchFound((Part)bodyPart)) continue;
                    return true;
                }
                catch (MessagingException e) {
                    anException = e;
                }
            }
        } else {
            String fileName = part.getFileName();
            if (fileName != null) {
                if (this.matchFound(fileName = this.cleanFileName(fileName))) {
                    if (this.isDebug) {
                        this.log("matched " + fileName);
                    }
                    return true;
                }
                if (this.unzipIsRequested && fileName.endsWith(ZIP_SUFFIX) && this.matchFoundInZip(part)) {
                    return true;
                }
            }
        }
        if (anException != null) {
            throw anException;
        }
        return false;
    }

    protected boolean matchFound(String fileName) {
        for (int j = 0; j < this.masks.length; ++j) {
            Mask mask = this.masks[j];
            boolean fMatch = mask.suffixMatch ? fileName.endsWith(mask.matchString) : fileName.equals(mask.matchString);
            if (!fMatch) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean matchFoundInZip(Part part) throws MessagingException, IOException {
        ZipInputStream zis = new ZipInputStream(part.getInputStream());
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                String fileName = zipEntry.getName();
                if (!this.matchFound(fileName)) continue;
                if (this.isDebug) {
                    this.log("matched " + part.getFileName() + "(" + fileName + ")");
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            zis.close();
        }
    }

    protected String cleanFileName(String fileName) {
        return fileName.toLowerCase(Locale.US).trim();
    }

    private static class Mask {
        public boolean suffixMatch;
        public String matchString;

        private Mask() {
        }
    }
}

