/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareNumericHeaderValue
extends GenericMatcher {
    private String headerName = null;
    private int comparisonOperator;
    private static final int LT = -2;
    private static final int LE = -1;
    private static final int EQ = 0;
    private static final int GE = 1;
    private static final int GT = 2;
    private Double headerValue;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() throws MessagingException {
        StringTokenizer st = new StringTokenizer(this.getCondition(), " \t", false);
        if (!st.hasMoreTokens()) {
            throw new MessagingException("Missing headerName");
        }
        this.headerName = st.nextToken().trim();
        if (!st.hasMoreTokens()) throw new MessagingException("Missing comparisonOperator");
        String comparisonOperatorString = st.nextToken().trim();
        if (comparisonOperatorString.equals("<") || comparisonOperatorString.equals("LT")) {
            this.comparisonOperator = -2;
        } else if (comparisonOperatorString.equals("<=") || comparisonOperatorString.equals("=<") || comparisonOperatorString.equals("LE")) {
            this.comparisonOperator = -1;
        } else if (comparisonOperatorString.equals("==") || comparisonOperatorString.equals("=") || comparisonOperatorString.equals("EQ")) {
            this.comparisonOperator = 0;
        } else if (comparisonOperatorString.equals(">=") || comparisonOperatorString.equals("=>") || comparisonOperatorString.equals("GE")) {
            this.comparisonOperator = 1;
        } else {
            if (!comparisonOperatorString.equals(">") && !comparisonOperatorString.equals("GT")) throw new MessagingException("Bad comparisonOperator: \"" + comparisonOperatorString + "\"");
            this.comparisonOperator = 2;
        }
        if (!st.hasMoreTokens()) throw new MessagingException("Missing headerValue threshold");
        String headerValueString = st.nextToken().trim();
        try {
            this.headerValue = Double.valueOf(headerValueString);
            return;
        }
        catch (NumberFormatException nfe) {
            throw new MessagingException("Bad header comparison value: \"" + headerValueString + "\"", (Exception)nfe);
        }
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        if (this.headerName == null) {
            throw new IllegalStateException("Null headerName");
        }
        MimeMessage message = mail.getMessage();
        String[] headerArray = message.getHeader(this.headerName);
        if (headerArray != null && headerArray.length > 0) {
            try {
                int comparison = Double.valueOf(headerArray[0].trim()).compareTo(this.headerValue);
                switch (this.comparisonOperator) {
                    case -2: {
                        if (comparison < 0) {
                            return mail.getRecipients();
                        }
                        break;
                    }
                    case -1: {
                        if (comparison <= 0) {
                            return mail.getRecipients();
                        }
                        break;
                    }
                    case 0: {
                        if (comparison == 0) {
                            return mail.getRecipients();
                        }
                        break;
                    }
                    case 1: {
                        if (comparison >= 0) {
                            return mail.getRecipients();
                        }
                        break;
                    }
                    case 2: {
                        if (comparison > 0) {
                            return mail.getRecipients();
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown comparisonOperator" + this.comparisonOperator);
                    }
                }
            }
            catch (NumberFormatException nfe) {
                throw new MessagingException("Bad header value found in message: \"" + headerArray[0] + "\"", (Exception)nfe);
            }
        }
        return null;
    }
}

